package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import com.sun.xml.ws.util.StringUtils;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by lightelfik on 7.07.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка работоспособности в случае ошибки в запросе")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SetBidsAudienceTargetsWrongRequest {
    private static final String CLIENT = AudienceTargetsLogins.LOGIN_TARGET46;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void emptyRequest() {
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(new SetBidsRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(SetBidsRequestMap.BIDS)));
    }

    @Test
    public void emptyArrayOfAudienceTargets() {
        int minElementsCount = 1;
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                new SetBidsRequestMap().withBids(),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(SetBidsRequestMap.BIDS), minElementsCount));
    }

    @Test
    public void nullInsteadOfAudienceTargets() {
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                new SetBidsRequestMap().withBids(new AudienceTargetSetBidsItemMap(null)),
                new Api5Error(8000, Api5ErrorDetailsJava.ARRAY_CONTAINS_NULL,
                        capitalize(SetBidsRequestMap.BIDS)));
    }

    @Test
    public void idAndAdgroupIdInOneRequest() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(new AudienceTargetSetBidsItemMap()
                        .withId(123l)
                        .withAdGroupId(123l)
                        .withStrategyPriority(PriorityEnum.LOW)),
                SetBidsExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        StringUtils.capitalize(AudienceTargetSetBidsItemMap.ID) + ", " +
                                StringUtils.capitalize(AudienceTargetSetBidsItemMap.AD_GROUP_ID) + ", " +
                                StringUtils.capitalize(AudienceTargetSetBidsItemMap.CAMPAIGN_ID))));
    }

    @Test
    public void idAndAdgroupIdandCampaignsIdInOneRequest() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(new AudienceTargetSetBidsItemMap()
                        .withId(123l)
                        .withAdGroupId(123l)
                        .withCampaignId(123l)
                        .withStrategyPriority(PriorityEnum.LOW)),
                SetBidsExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        StringUtils.capitalize(AudienceTargetSetBidsItemMap.ID) + ", " +
                                StringUtils.capitalize(AudienceTargetSetBidsItemMap.AD_GROUP_ID) + ", " +
                                StringUtils.capitalize(AudienceTargetSetBidsItemMap.CAMPAIGN_ID))));
    }

}
