package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by lightelfik on 7.07.16.
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка работоспособности в случае неправильного формата запроса")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SetBidsAudienceTargetsWrongRequestFormat {
    private static final String CLIENT = AudienceTargetsLogins.LOGIN_TARGET46;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject bid = new JSONObject();
        bid.put(capitalize(AudienceTargetSetBidsItemMap.ID), 111);
        bid.put(capitalize(AudienceTargetSetBidsItemMap.CONTEXT_BID), 1000000);
        request.put(SetBidsRequestMap.BIDS, new Object[]{bid});
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(SetBidsRequestMap.BIDS))
        );
    }

    @Test
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject bid = new JSONObject();
        bid.put(capitalize(AudienceTargetSetBidsItemMap.ID), 111);
        bid.put(capitalize(AudienceTargetSetBidsItemMap.CONTEXT_BID), 1000000);
        request.put(capitalize(SetBidsRequestMap.BIDS), new Object[]{bid});
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT)
        );
    }

    @Test
    public void notArrayInBids() {
        JSONObject request = new JSONObject();
        JSONObject bid = new JSONObject();
        bid.put(capitalize(AudienceTargetSetBidsItemMap.ID), 111);
        bid.put(capitalize(AudienceTargetSetBidsItemMap.CONTEXT_BID), 1000000);
        request.put(capitalize(SetBidsRequestMap.BIDS), bid);
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(SetBidsRequestMap.BIDS))
        );
    }

    @Test
    public void arrayInElementOfBids() {
        JSONObject request = new JSONObject();
        JSONObject bid = new JSONObject();
        bid.put(capitalize(AudienceTargetSetBidsItemMap.ID), 111);
        bid.put(capitalize(AudienceTargetSetBidsItemMap.CONTEXT_BID), 1000000);
        request.put(capitalize(SetBidsRequestMap.BIDS), new Object[]{new Object[]{bid}});
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        path(SetBidsRequestMap.BIDS))
        );
    }

    @Test
    public void invalidFieldInBids() {
        JSONObject request = new JSONObject();
        JSONObject bid = new JSONObject();
        bid.put(AudienceTargetSetBidsItemMap.ID, 111);
        bid.put(capitalize(AudienceTargetSetBidsItemMap.CONTEXT_BID), 1000000);
        request.put(capitalize(SetBidsRequestMap.BIDS), new Object[]{bid});
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(SetBidsRequestMap.BIDS), AudienceTargetSetBidsItemMap.ID)
        );
    }

    @Test
    public void arrayInContextBid() {
        JSONObject request = new JSONObject();
        JSONObject bid = new JSONObject();
        bid.put(capitalize(AudienceTargetSetBidsItemMap.ID), 111);
        bid.put(capitalize(AudienceTargetSetBidsItemMap.CONTEXT_BID), new Object[]{1000000});
        request.put(capitalize(SetBidsRequestMap.BIDS), new Object[]{bid});
        api.userSteps.audienceTargetsSteps().expectErrorOnSetBids(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(SetBidsRequestMap.BIDS, AudienceTargetSetBidsItemMap.CONTEXT_BID))
        );
    }
}


