package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка выставления ContextBid при разных стратегиях")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class SetBidsContextBidStrategiesTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET44;
    private static final Currency CURRENCY = Currency.RUB;

    private static final long CONTEXT_BID = 200_000_000L;
    private static final long GOAL_ID = MetrikaGoals.getGoalForLogin(LOGIN);
    private Long targetId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public TextCampaignSearchStrategyTypeEnum searchStrategyEnum;

    @Parameterized.Parameter(1)
    public TextCampaignNetworkStrategyTypeEnum networkStrategyEnum;

    @Parameterized.Parameter(2)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(3)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(4)
    public SetBidsExpectedResult expectedResult;

    @Parameterized.Parameters(name = "SearchStrategy = {0}, NetworkStrategy = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA,
                        TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT,
                        new TextCampaignSearchStrategyMap().defaultAverageCpa(CURRENCY, GOAL_ID),
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        SetBidsExpectedResult.errors(
                                new Notification(9600, Api5ErrorDetails.FOR_AUTO_STRATEGY_FIELD_MUST_BE_SPECIFIED,
                                        capitalize(AudienceTargetSetBidsItemMap.STRATEGY_PRIORITY))
                        )},

                {TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION,
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE,
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        SetBidsExpectedResult.successWithId()},

                {TextCampaignSearchStrategyTypeEnum.SERVING_OFF,
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE,
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage(),
                        SetBidsExpectedResult.successWithId()},

                {TextCampaignSearchStrategyTypeEnum.SERVING_OFF,
                        TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPA,
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpc(CURRENCY),
                        SetBidsExpectedResult.errors(
                                new Notification(9600, Api5ErrorDetails.FOR_AUTO_STRATEGY_FIELD_MUST_BE_SPECIFIED,
                                        capitalize(AudienceTargetSetBidsItemMap.STRATEGY_PRIORITY))
                        )},

        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, GOAL_ID, 100L, 100L);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))));

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        targetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
    }

    @Test
    public void setBids() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withId(targetId)
                                .withContextBid(CONTEXT_BID)
                ), expectedResult);
    }
}
