package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRetargetingRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class SetBidsCpmBannerTest {

    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET47;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignId;
    private static Long cpmBannerAdGroupId;
    private static Long cpmVideoAdGroupId;
    private static Long cpmBannerTargetId;
    private static Long cpmVideoTargetId;

    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

    private static Money bidBefore = MoneyCurrency.get(Currency.RUB).getMinCpmPrice();
    private static Money bidAfter = MoneyCurrency.get(Currency.RUB).getMinCpmPrice().getNext();


    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long userListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, LOGIN);
        RetargetingConditionsRecord retargetingConditionsRecord =
                dbSteps.retargetingConditionSteps().getRetargeingConditionByRetCondId(userListsId);
        retargetingConditionsRecord
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests);
        dbSteps.retargetingConditionSteps().updateRetargetingCondition(retargetingConditionsRecord);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        cpmBannerAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        cpmVideoAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        cpmBannerTargetId =
                api.userSteps.audienceTargetsSteps().addWithRetargetingList(cpmBannerAdGroupId, userListsId);
        cpmVideoTargetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(cpmVideoAdGroupId, userListsId);
        dbSteps.adGroupsSteps().setType(cpmVideoAdGroupId, PhrasesAdgroupType.cpm_video);
    }

    @Before
    public void resetBids() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                        .withId(cpmBannerTargetId)
                                        .withContextBid(bidBefore.bidLong().longValue()),
                                new AudienceTargetSetBidsItemMap()
                                        .withId(cpmVideoTargetId)
                                        .withContextBid(bidBefore.bidLong().longValue())),
                SetBidsExpectedResult.successWithId(),
                SetBidsExpectedResult.successWithId());
        BidsRetargetingRecord bidsRetargetingRecord =
                dbSteps.bidsSteps().getBidsRetargetingRecordByRetId(cpmBannerTargetId);
        assumeThat("ставка перед тестом правильная",
                Money.valueOf(bidsRetargetingRecord.getPriceContext(), Currency.RUB), equalTo(bidBefore));
        bidsRetargetingRecord = dbSteps.bidsSteps().getBidsRetargetingRecordByRetId(cpmVideoTargetId);
        assumeThat("ставка перед тестом правильная",
                Money.valueOf(bidsRetargetingRecord.getPriceContext(), Currency.RUB), equalTo(bidBefore));
    }

    @Test
    public void setBidsCpmBannerId() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withId(cpmBannerTargetId)
                                .withContextBid(bidAfter.bidLong().longValue())),
                SetBidsExpectedResult.successWithId());
        BidsRetargetingRecord bidsRetargetingRecord =
                dbSteps.bidsSteps().getBidsRetargetingRecordByRetId(cpmBannerTargetId);
        assertThat("ставка изменилась",
                Money.valueOf(bidsRetargetingRecord.getPriceContext(), Currency.RUB), equalTo(bidAfter));
    }

    @Test
    public void setBidsCpmVideoId() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withId(cpmVideoTargetId)
                                .withContextBid(bidAfter.bidLong().longValue())),
                SetBidsExpectedResult.successWithId());
        BidsRetargetingRecord bidsRetargetingRecord =
                dbSteps.bidsSteps().getBidsRetargetingRecordByRetId(cpmVideoTargetId);
        assertThat("ставка изменилась",
                Money.valueOf(bidsRetargetingRecord.getPriceContext(), Currency.RUB), equalTo(bidAfter));
    }

    @Test
    public void setBidsCpmBannerAdGroupId() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withAdGroupId(cpmBannerAdGroupId)
                                .withContextBid(bidAfter.bidLong().longValue())),
                SetBidsExpectedResult.successWithAdGroupId());
        BidsRetargetingRecord bidsRetargetingRecord =
                dbSteps.bidsSteps().getBidsRetargetingRecordByRetId(cpmBannerTargetId);
        assertThat("ставка изменилась",
                Money.valueOf(bidsRetargetingRecord.getPriceContext(), Currency.RUB), equalTo(bidAfter));
    }

    @Test
    public void setBidsCpmVideoAdGroupId() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withAdGroupId(cpmVideoAdGroupId)
                                .withContextBid(bidAfter.bidLong().longValue())),
                SetBidsExpectedResult.successWithAdGroupId());
        BidsRetargetingRecord bidsRetargetingRecord =
                dbSteps.bidsSteps().getBidsRetargetingRecordByRetId(cpmVideoTargetId);
        assertThat("ставка изменилась",
                Money.valueOf(bidsRetargetingRecord.getPriceContext(), Currency.RUB), equalTo(bidAfter));
    }

    @Test
    public void setBidsCampaignId() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(campaignId)
                                .withContextBid(bidAfter.bidLong().longValue())),
                SetBidsExpectedResult.successWithCampaignId());
        BidsRetargetingRecord bidsRetargetingRecord =
                dbSteps.bidsSteps().getBidsRetargetingRecordByRetId(cpmBannerTargetId);
        assertThat("ставка изменилась",
                Money.valueOf(bidsRetargetingRecord.getPriceContext(), Currency.RUB), equalTo(bidAfter));
        bidsRetargetingRecord = dbSteps.bidsSteps().getBidsRetargetingRecordByRetId(cpmVideoTargetId);
        assertThat("ставка изменилась",
                Money.valueOf(bidsRetargetingRecord.getPriceContext(), Currency.RUB), equalTo(bidAfter));
    }

    @Test
    public void setBidsLessThanMinPrice() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withId(cpmBannerTargetId)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getMinCpmPrice().getPrevious().bidLong()
                                        .longValue())),
                SetBidsExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS,
                        capitalize(AudienceTargetAddItemMap.CONTEXT_BID),
                        MoneyCurrency.get(Currency.RUB).getMinCpmPrice()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        MoneyCurrency.get(Currency.RUB)
                                .getJavaAPIAbbreviation(DirectTestRunProperties.getInstance().getDirectAPILocale()))));
    }

    @Test
    public void setBidsMoreThanMaxPrice() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withId(cpmBannerTargetId)
                                .withContextBid(MoneyCurrency.get(Currency.RUB).getMaxCpmPrice().getNext().bidLong()
                                        .longValue())),
                SetBidsExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_MORE,
                        capitalize(AudienceTargetAddItemMap.CONTEXT_BID),
                        MoneyCurrency.get(Currency.RUB).getMaxCpmPrice()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        MoneyCurrency.get(Currency.RUB)
                                .getJavaAPIAbbreviation(DirectTestRunProperties.getInstance().getDirectAPILocale()))));
    }
}
