package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-10622
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Успешно выставляется ContextBid для AudienceTarget с интересом")
@Issue("https://st.yandex-team.ru/DIRECT-56850")
public class SetBidsInterestTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET69;
    private static Long goalId;
    private static Long interestId;
    private static Long retargetingListId;
    private static List<Long> targetIds;
    private static Long cid;
    private static Long pid;
    private static long minimumBid = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();
    private static long maximumBid = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.as(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        interestId = api.userSteps.dictionariesSteps().getInterestIdByIsTargetable(YesNoEnum.YES);
        targetIds = api.userSteps.audienceTargetsSteps().add(
                new AddRequestMap()
                        .withAudienceTargets(
                                new AudienceTargetAddItemMap()
                                        .withAdGroupId(pid)
                                        .withRetargetingListId(retargetingListId),
                                new AudienceTargetAddItemMap()
                                        .withAdGroupId(pid)
                                        .withInterestId(interestId)
                        ));
        assumeThat("получено два AudienceTargets", targetIds, hasSize(2));
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void setContextBidAdGroup() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withAdGroupId(pid)
                                .withContextBid(maximumBid)),
                SetBidsExpectedResult.successWithAdGroupId());
        List<AudienceTargetGetItem> getItems = api.userSteps.audienceTargetsSteps().audienceTargetsGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withAdGroupIds(pid))).getAudienceTargets();
        boolean everyItemContextBidExpected =
                getItems.stream()
                        .allMatch(getItem -> getItem.getContextBid() == maximumBid);
        assertThat("ставка верная у всех элементов группы", everyItemContextBidExpected, equalTo(true));
    }

    @Test
    public void setContextBidCampaign() {
        long bid = maximumBid - minimumBid;
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(cid)
                                .withContextBid(bid)),
                SetBidsExpectedResult.successWithCampaignId());
        List<AudienceTargetGetItem> getItems = api.userSteps.audienceTargetsSteps().audienceTargetsGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.CONTEXT_BID)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withCampaignIds(cid))).getAudienceTargets();
        boolean everyItemContextBidExpected =
                getItems.stream()
                        .allMatch(getItem -> getItem.getContextBid() == bid);
        assertThat("ставка верная у всех элементов кампании", everyItemContextBidExpected, equalTo(true));
    }
}

