package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.List;

import com.sun.xml.ws.util.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка работы метода с невалидным CampaignId")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SetBidsInvalidCampaignIdTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET49;
    private static final String LOGIN_ANOTHER = AudienceTargetsLogins.LOGIN_TARGET50;
    private static final long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long retargetingListId;
    private static Long cid;
    private static Long pid;
    private static Long id;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void init() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN_ANOTHER);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
    }

    @Before
    public void before() {
        api.as(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        List<Long> ids = api.userSteps.audienceTargetsSteps().add(new AddRequestMap()
                .withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(pid)
                        .withRetargetingListId(retargetingListId)
                        .withContextBid(MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue()))
        );
        assumeThat("создался один объект", ids, iterableWithSize(1));
        id = ids.get(0);
    }

    @Test
    public void zeroCampaignId() {
        //DIRECT-58281
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(0l)
                                .withContextBid(BID)),
                SetBidsExpectedResult.errors(
                        new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                StringUtils.capitalize(AudienceTargetSetBidsItemMap.CAMPAIGN_ID)))
        );
    }

    @Test
    public void negativeCampaignId() {
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(-1l)
                                .withContextBid(BID)),
                SetBidsExpectedResult.errors(
                        new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                StringUtils.capitalize(AudienceTargetSetBidsItemMap.CAMPAIGN_ID)))
        );
    }

    @Test
    public void nonExistentCampaignId() {
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(cid + 10000)
                                .withContextBid(BID)),
                SetBidsExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetailsJava.AUDIENCE_TARGETS_FOR_PARAMETERS_NOT_FOUND))
        );
    }

    @Test
    public void campaignWithDeletedId() {
        api.userSteps.audienceTargetsSteps().delete(id);
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(cid)
                                .withContextBid(BID)),
                SetBidsExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetailsJava.AUDIENCE_TARGETS_FOR_PARAMETERS_NOT_FOUND))
        );
    }

    @Test
    public void deletedCampaign() {
        api.userSteps.campaignSteps().campaignsDelete(cid);
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(cid)
                                .withContextBid(BID)),
                SetBidsExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetailsJava.AUDIENCE_TARGETS_FOR_PARAMETERS_NOT_FOUND))
        );
    }

    @Test
    public void archivedCampaign() {
        api.userSteps.campaignSteps().campaignsSuspend(cid);
        api.userSteps.campaignSteps().campaignsArchive(cid);
        api.as(LOGIN).userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(cid)
                                .withContextBid(BID)),
                SetBidsExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.SET_BIDS_FOR_ARCHIVED_CAMPAIGN_IS_DENIED, cid))
        );
    }

    @Test
    public void anotherClientsCampaignId() {
        api.as(LOGIN_ANOTHER).userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(cid)
                                .withContextBid(BID)),
                SetBidsExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetailsJava.AUDIENCE_TARGETS_FOR_PARAMETERS_NOT_FOUND))
        );
    }
}

