package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.sun.xml.ws.util.StringUtils.capitalize;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка обязательных полей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SetBidsMandatoryFieldsTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET52;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long pid;
    private static Long cid;
    private static Long retargetingListsId;
    private static List<Long> audienceTargetsIds;
    private static Long minBid = MoneyCurrency.get(User.get(LOGIN).getCurrency()).getLongMinPrice().longValue();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        audienceTargetsIds = api.userSteps.audienceTargetsSteps().add(
                new AddRequestMap().withAudienceTargets(new AudienceTargetAddItemMap()
                        .withRetargetingListId(retargetingListsId)
                        .withAdGroupId(pid)
                        .withContextBid(minBid)
                )
        );
    }

    @Test
    public void testWithoutIds() {
        int random  = RandomUtils.getRandomInteger(1, 100);
        long bid = minBid + random * 10000;
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withContextBid(bid)
                ), SetBidsExpectedResult.errors(
                        new Notification(5008, Api5ErrorDetails.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                capitalize(AudienceTargetSetBidsItemMap.ID) + ", " +
                                capitalize(AudienceTargetSetBidsItemMap.AD_GROUP_ID) + ", " +
                                capitalize(AudienceTargetSetBidsItemMap.CAMPAIGN_ID))));
    }

    @Test
    public void testWithoutContextPrice() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withId(audienceTargetsIds.get(0))),
                SetBidsExpectedResult.errors(
                        new Notification(9600,
                                Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_FOR_STRATEGY,
                                capitalize(AudienceTargetSetBidsItemMap.CONTEXT_BID))));
    }

    @Test
    public void testWithoutStrategyPriority() {
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(cid)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB))
                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultServingOff())))));
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withId(audienceTargetsIds.get(0))),
                SetBidsExpectedResult.errors(
                        new Notification(9600, Api5ErrorDetails.FOR_AUTO_STRATEGY_FIELD_MUST_BE_SPECIFIED,
                                capitalize(AudienceTargetSetBidsItemMap.STRATEGY_PRIORITY))));
    }

}
