package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordAddMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка невалидных значений ContextBid")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SetBidsNotPositiveContextBidTest {
    private static final String CLIENT = AudienceTargetsLogins.LOGIN_TARGET53;
    private Long targetId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовка данных для теста")
    public void createAdGroup() {
        api.as(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup((int) campaignId);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(CLIENT, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        targetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid,retargetingListsId);
    }

    @Test
    public void setNegativeContextBid() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withId(targetId)
                                .withContextBid(-1L)),
                SetBidsExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS,
                        capitalize(KeywordAddMap.CONTEXT_BID),
                        MoneyCurrency.get(Currency.RUB).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT),
                        MoneyCurrency.get(Currency.RUB).getJavaAPIAbbreviation(api.locale()))));
    }

    @Test
    public void setZeroContextBid() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(
                new SetBidsRequestMap().withBids(
                        new AudienceTargetSetBidsItemMap()
                                .withId(targetId)
                                .withContextBid(0L)),
                SetBidsExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS,
                        capitalize(KeywordAddMap.CONTEXT_BID),
                        MoneyCurrency.get(Currency.RUB).getMinPrice().stringValue(MoneyFormat.TWO_DIGITS_POINT),
                        MoneyCurrency.get(Currency.RUB).getJavaAPIAbbreviation(api.locale()))));
    }

}
