package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.List;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-10622
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Успешно выставляется StrategyPriority для AudienceTarget с интересом")
@Issue("https://st.yandex-team.ru/DIRECT-56850")
public class SetBidsStrategyPriorityForInterestTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET69;
    private static Long cid;
    private static Long pid;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.as(LOGIN);
        cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaignWithStrategies(
                new MobileAppCampaignSearchStrategyAddMap().defaultServingOff(),
                new MobileAppCampaignNetworkStrategyAddMap().defaultAverageCpc(Currency.RUB)
        );
        pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        Long interestId = api.userSteps.dictionariesSteps().getInterestIdByIsTargetable(YesNoEnum.YES);
        List<Long> targetIds = api.userSteps.audienceTargetsSteps().add(
                new AddRequestMap()
                        .withAudienceTargets(
                                new AudienceTargetAddItemMap()
                                        .withAdGroupId(pid)
                                        .withRetargetingListId(retargetingListId),
                                new AudienceTargetAddItemMap()
                                        .withAdGroupId(pid)
                                        .withInterestId(interestId)
                        ));
        assumeThat("получено два AudienceTargets", targetIds, hasSize(2));
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void setStrategyPriorityAdGroup() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withAdGroupId(pid)
                                .withStrategyPriority(PriorityEnum.LOW)),
                SetBidsExpectedResult.successWithAdGroupId());
        List<AudienceTargetGetItem> getItems = api.userSteps.audienceTargetsSteps().audienceTargetsGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.STRATEGY_PRIORITY)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withAdGroupIds(pid))).getAudienceTargets();
        boolean everyItemPriorityExpected =
                getItems.stream()
                        .allMatch(getItem -> getItem.getStrategyPriority() == PriorityEnum.LOW);
        assertThat("приоритет верный у всех элементов кампании", everyItemPriorityExpected, equalTo(true));
    }

    @Test
    public void setStrategyPriorityCampaign() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withCampaignId(cid)
                                .withStrategyPriority(PriorityEnum.HIGH)),
                SetBidsExpectedResult.successWithCampaignId());
        List<AudienceTargetGetItem> getItems = api.userSteps.audienceTargetsSteps().audienceTargetsGet(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.STRATEGY_PRIORITY)
                        .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                .withCampaignIds(cid))).getAudienceTargets();
        boolean everyItemPriorityExpected =
                getItems.stream()
                        .allMatch(getItem -> getItem.getStrategyPriority() == PriorityEnum.HIGH);
        assertThat("приоритет верный у всех элементов группы", everyItemPriorityExpected, equalTo(true));
    }
}

