package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetGetItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Успешно выставляется StrategyPriority")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class SetBidsStrategyPriorityTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET55;
    private Long targetId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public PriorityEnum expectedPriority;

    @Parameterized.Parameters(name = "StrategyPriority = {0}")
    public static Iterable<Object[]> stateValues() {
        return Stream.of(PriorityEnum.values())
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    @BeforeClass
    public static void prepareKeyword() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void setAutobudgetPriority() {
        long campaignId =
                api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultAverageCpc(Currency.RUB));
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup((int) campaignId);
        Long goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        targetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid,retargetingListsId);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withId(targetId)
                                .withStrategyPriority(expectedPriority)),
                SetBidsExpectedResult.successWithId());
    }

    @Test
    public void setBidsStrategyPriorityTest() {
        List<AudienceTargetGetItem> targets = api.userSteps.audienceTargetsSteps().get(
                new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.STRATEGY_PRIORITY)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap()
                                        .withIds(targetId))
        );

        assertThat("вернулось верное значение приоритета стратегии", targets,
                beanEquivalentV5(Arrays.asList(
                        new AudienceTargetGetItemMap().withStrategyPriority(expectedPriority).getBean())));
    }
}
