package ru.yandex.autotests.direct.api.audiencetargets.setbids;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSetBidsItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SetBidsRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.SetBidsExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SET_BIDS)
@Description("Проверка выставления StarategyPriority с разными стратегиями")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class SetBidsStrategyPriorityWithDiffStrategiesTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET56;
    private static Long campaignId;
    private static Long targetId;
    private static final long GOAL_ID = MetrikaGoals.getGoalForLogin(LOGIN);
    private static Long pid;
    private static Long goalId;
    private static Long retargetingListsId;
    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public TextCampaignSearchStrategyTypeEnum searchStrategyName;

    @Parameterized.Parameter(1)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(2)
    public SetBidsExpectedResult expectedResult;

    @Parameterized.Parameters(name = "Стратегия на поиске = {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION,
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        SetBidsExpectedResult.successWithId()},

                {TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS,
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        SetBidsExpectedResult.successWithId()},

                {TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE,
                        new TextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(Currency.RUB, GOAL_ID),
                        SetBidsExpectedResult.successWithId()},

                {TextCampaignSearchStrategyTypeEnum.AVERAGE_CPC,
                        new TextCampaignSearchStrategyMap().defaultAverageCpc(Currency.RUB),
                        SetBidsExpectedResult.successWithId()},

                {TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA,
                        new TextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, GOAL_ID),
                        SetBidsExpectedResult.successWithId()},

                {TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI,
                        new TextCampaignSearchStrategyMap().defaultAverageRoi(GOAL_ID),
                        SetBidsExpectedResult.successWithId()},
        });
    }

    @BeforeClass
    public static void addCampaign(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().addCampMetrikaGoals(campaignId, GOAL_ID, 100L, 100L);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        goalId = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId);
        targetId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid,retargetingListsId);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(searchStrategy)
                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultServingOff())))),
                ExpectedResult.success());
    }

    @Test
    @Description("https://st.yandex-team.ru/DIRECT-57623")
    public void setStrategyPriority() {
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSetBids(new SetBidsRequestMap()
                        .withBids(new AudienceTargetSetBidsItemMap()
                                .withId(targetId)
                                .withStrategyPriority(PriorityEnum.LOW)),
                expectedResult);
    }
}
