package ru.yandex.autotests.direct.api.audiencetargets.suspend;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SUSPEND)
@Description("Валидация JSON-запроса при удалении")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SuspendAudienceTargetsJsonValidationTest {
    private static final Long ID = 123L;
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET66;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void arrayInSelectionCriteriaField() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), ID);
        request.put(StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        api.userSteps.audienceTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.AUDIENCE_TARGETS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(SuspendRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void notAnArrayInIdsField() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), 0L);
        request.put(StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.audienceTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.AUDIENCE_TARGETS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                        path(SuspendRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    public void stringInIdsArray() {
        String value = "WrongId";
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), new String[]{value});
        request.put(StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.audienceTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.AUDIENCE_TARGETS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(SuspendRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    public void arrayInIdsArray() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(StringUtils.capitalize(IdsCriteriaMap.IDS), new Long[][]{new Long[]{0L}});
        request.put(StringUtils.capitalize(SuspendRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.audienceTargetsSteps().shouldGetJSONErrorOn(
                ServiceNames.AUDIENCE_TARGETS,
                LOGIN,
                Action.SUSPEND,
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(SuspendRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }
}
