package ru.yandex.autotests.direct.api.audiencetargets.suspend;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SUSPEND)
@Description("Проверка корректности работы метода для разных ролей")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@RunWith(Parameterized.class)
public class SuspendAudienceTargetsRolesTest {
    private static final String CLIENT = "at-client-webpages";
    private static final String CLIENT_REP = "at-rep-client-webpages";
    private static final String AGENCY = "at-agency-webpages";
    private static final String AGENCY_REP = "at-rep-agency-webpages";
    private static final String SUBCLIENT = "at-subclient-webpages";
    private static final String MANAGER = Logins.MANAGER_DEFAULT;
    private static final String SERV_CLIENT = "at-serv-webpages";
    private static final String SUPER = Logins.SUPER_LOGIN;
    private static final String SUPER_READER = Logins.SUPER_READER;
    private static final String PLACER = Logins.PLACER;
    private static final String SUPPORT = Logins.SUPPORT;
    private static final String MEDIA = Logins.MEDIA;
    private Long targetId;

    private static final Api5Error noRights = new Api5Error(54);

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String loginToAddRetargetingList;

    @Parameterized.Parameter(2)
    public String apiUserLogin;

    @Parameterized.Parameter(3)
    public String login;

    @Parameterized.Parameter(4)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {

        return Arrays.asList(new Object[][]{
                {"Остановка условий от имени менеджера", MANAGER, MANAGER, SERV_CLIENT,
                        null},

                {"Остановка условий от имени вешальщика", SUPER, PLACER, CLIENT,
                        noRights},

                {"Остановка условий от имени саппорта", SUPER, SUPPORT, CLIENT,
                        null},

                {"Остановка условий от имени супера", SUPER, SUPER, CLIENT,
                        null},

                {"Остановка условий от имени медиапланера", SUPER, MEDIA, CLIENT,
                        noRights},

                {"Остановка условий от имени суперридера", SUPER, SUPER_READER, CLIENT,
                        noRights},

                {"Остановка условий от имени клиента для самого себя", SUPER, CLIENT, CLIENT,
                        null},

                {"Остановка условий от имени представителя клиента для клиента", SUPER, CLIENT_REP, CLIENT,
                        null},

                {"Остановка условий от имени агенства для субклиента", AGENCY, AGENCY, SUBCLIENT,
                        null},

                {"Остановка условий от имени представителя агенства для субклиента", AGENCY_REP, AGENCY_REP, SUBCLIENT,
                        null},

                {"Остановка условий от имени субклиента для самого себя", AGENCY, SUBCLIENT, SUBCLIENT,
                        noRights}
        });
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AGENCY_REP);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT);
        api.as(loginToAddRetargetingList);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid, login);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(login, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, login);
        targetId = api.userSteps.audienceTargetsSteps().add(
                login,
                new AddRequestMap()
                        .withAudienceTargets(new AudienceTargetAddItemMap()
                                .withAdGroupId(pid)
                                .withRetargetingListId(retargetingListsId)
                        )).get(0);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
    }

    @Test
    public void suspendUsingLogin() {
        api.as(apiUserLogin);

        api.userSteps.audienceTargetsSteps().expectErrorOnAudienceTargetsSuspend(
                new SuspendRequestMap().withSelectionCriteria(
                        new IdsCriteriaMap()
                                .withIds(targetId)),
                login,
                expectedError
        );
    }
}
