package ru.yandex.autotests.direct.api.audiencetargets.suspend;

import java.util.List;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsFeatures;
import ru.yandex.autotests.direct.api.audiencetargets.AudienceTargetsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/*
 * Created by buhter on 03/03/16
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(AudienceTargetsFeatures.SUSPEND)
@Description("Проверка корректности работы метода с валидными данными")
@Issue("https://st.yandex-team.ru/DIRECT-48447")
public class SuspendAudienceTargetsTest {
    private static final String LOGIN = AudienceTargetsLogins.LOGIN_TARGET64;
    private static List<Long> goalIds;
    private static Long interestId;
    private Long targetId1;
    private Long targetId2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL);
        assumeThat("у клиента должно быть > 1 цели", goalIds.size(), greaterThan(1));
        interestId = api.userSteps.dictionariesSteps().getInterestIdByIsTargetable(YesNoEnum.YES);
    }

    @Test
    public void successCallWithValidId() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0));
        targetId1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(new SuspendRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1)), ExpectedResult.success());
    }

    @Test
    public void successCallWithTwoValidIds() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0));
        targetId1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
        retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(1));
        targetId2 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1, targetId2)),
                ExpectedResult.success(),
                ExpectedResult.success());
    }

    @Test
    public void suspendSuspendedId() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0));
        targetId1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(new SuspendRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1)), ExpectedResult.success());
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1)),
                ExpectedResult.warnings(new Notification(10020, Api5ErrorDetails.AUDIENCE_TARGET_ALREADY_STOPPED)));
    }

    @Test
    public void oneValidAndOneInvalidIds() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0));
        targetId1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(new SuspendRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1, targetId1 + 10000)),
                ExpectedResult.success(),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.AUDIENCE_TARGETS_NOT_FOUND)));
    }

    @Test
    @Description("https://st.yandex-team.ru/TESTIRT-10622")
    public void successCallWithInterest() {
        Long cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        Long interestId = api.userSteps.dictionariesSteps().getInterestIdByIsTargetable(YesNoEnum.YES);
        targetId1 = api.userSteps.audienceTargetsSteps().addWithInterest(pid, interestId);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(new SuspendRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1)), ExpectedResult.success());
    }


    @Test
    @Description("https://st.yandex-team.ru/TESTIRT-10622")
    public void suspendLastAudienceTargetWithInterestFromSynchronizedAdGroup() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long cid = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultMobileGroup(cid);
        targetId1 = api.userSteps.audienceTargetsSteps().addWithInterest(pid, interestId);
        api.userSteps.campaignFakeSteps().setBSSynced(cid, true);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.YES);
        // тут была простановка bids_retargeting.statusBsSynced = Yes
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(new SuspendRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1)), ExpectedResult.success());
    }

    @Test
    public void suspendInCpmBannerAdGroup() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.CPM_BANNER);
        Long pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(cid);
        Long retargetingListsId =
                api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0), LOGIN);
        RetargetingConditionsRecord retargetingConditionsRecord =
                dbSteps.retargetingConditionSteps().getRetargeingConditionByRetCondId(retargetingListsId);
        retargetingConditionsRecord
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests);
        dbSteps.retargetingConditionSteps().updateRetargetingCondition(retargetingConditionsRecord);
        targetId1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(new SuspendRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1)), ExpectedResult.success());
    }

    @Test
    public void suspendInCpmVideoAdGroup() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(cid, CampaignsType.CPM_BANNER);
        Long pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(cid);
        Long retargetingListsId =
                api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalIds.get(0), LOGIN);
        RetargetingConditionsRecord retargetingConditionsRecord =
                dbSteps.retargetingConditionSteps().getRetargeingConditionByRetCondId(retargetingListsId);
        retargetingConditionsRecord
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests);
        dbSteps.retargetingConditionSteps().updateRetargetingCondition(retargetingConditionsRecord);
        targetId1 = api.userSteps.audienceTargetsSteps().addWithRetargetingList(pid, retargetingListsId);
        dbSteps.adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_video);
        api.userSteps.audienceTargetsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(targetId1)),
                ExpectedResult.success());
    }
}
