package ru.yandex.autotests.direct.api.audiencetargets.units;

import java.lang.reflect.InvocationTargetException;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

import com.yandex.direct.api.v5.audiencetargets.GetRequest;
import org.apache.commons.beanutils.BeanUtils;

@XmlAccessorType(XmlAccessType.FIELD)
class BadGetRequest extends GetRequest {

    @XmlElement(name = "ExtraFieldToProvokeError")
    protected String extraField;

    BadGetRequest(GetRequest origin) {
        super();
        try {
            BeanUtils.copyProperties(this, origin);
            this.selectionCriteria = null;
            this.extraField = "someString";

        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public String getExtraField() {
        return extraField;
    }

    public void setExtraField(String extraField) {
        this.extraField = extraField;
    }

}
