package ru.yandex.autotests.direct.api.audiencetargets.units;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTester;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTesterImpl;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;

@Aqua.Test
@Issue("https://st.yandex-team.ru/TESTIRT-10668")
@Features(ApiFeatures.UNITS)
@Description("Проверка определения, с кого списывать баллы в случае ошибки. Сервис AudienceTargets")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UnitsAudienceTargetsErrorTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static UnitsWithdrawalTester tester = new UnitsWithdrawalTesterImpl(api);

    private static UnitsAudienceTargetsErrorTestData dataProvider = new UnitsAudienceTargetsErrorTestData(api);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter()  public String description;
    @Parameter(1) public String operatorLogin;
    @Parameter(2) public String clientLogin;
    @Parameter(3) public String useOperatorUnits;
    @Parameter(4) public int unitsDelta;
    @Parameter(5) public Collection<String> expectedUnitsWithdrawLogins;
    @Parameter(6) public Collection<String> expectedUnitsKeepLogins;
    @Parameter(7) public Function<String, String> serviceCall;

    @Parameters(name = "{0}; Operator: {1}; Client-Login: {2}; Use-Operator-Units: {3}")
    public static Iterable<Object[]> parameters() {
        return dataProvider.provideData();
    }

    @BeforeClass
    public static void init() {
        tester.init();
    }

    @Before
    public void reset() {
        tester.resetBuilder(operatorLogin, clientLogin)
                .useOperatorUnits(useOperatorUnits)
                .unitsDiff(unitsDelta)
                .execute();
    }

    @Test
    public void testUnitsWithdrawal() {
        Supplier<String> callWithErrorAndHeaderCheck = () -> serviceCall.apply(clientLogin);
        tester.testUnitsWithdrawal(callWithErrorAndHeaderCheck, expectedUnitsWithdrawLogins, expectedUnitsKeepLogins);
    }

    @AfterClass
    public static void shutdown() {
        tester.shutdown();
    }

}
