package ru.yandex.autotests.direct.api.audiencetargets.units;

import com.google.common.collect.Iterables;
import com.yandex.direct.api.v5.audiencetargets.ApiException;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetsPort;
import com.yandex.direct.api.v5.audiencetargets.GetRequest;

import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalPageErrorTestData;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataProvider;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataProviderImpl;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalWsdlErrorTestData;

import static ru.yandex.autotests.directapi.test.units.UnitsHeaderUtil.getUnitsUsedLoginHeader;
import static ru.yandex.autotests.directapi.test.units.UnitsWithdrawalErrorTestDataUtil.errorExpected;

class UnitsAudienceTargetsErrorTestData {

    private final UnitsWithdrawalTestDataProvider dataProvider;

    private final ApiSteps api;

    public UnitsAudienceTargetsErrorTestData(ApiSteps api) {
        this.api = api;
        this.dataProvider = new UnitsWithdrawalTestDataProviderImpl();
    }

    Iterable<Object[]> provideData() {

        return Iterables.concat(

                dataProvider.buildDataSets(

                        UnitsWithdrawalPageErrorTestData.pageLimitExceeded(),

                        getUnitsUsedLoginHeader((String clientLogin) -> {
                            AudienceTargetsPort port = api.userSteps.soapClientV5().audienceTargetsService(clientLogin);

                            errorExpected(
                                    ApiException.class,
                                    () -> port.get((GetRequest) new GetRequestMap()
                                            .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                                    .withIds(0L))
                                            .withFieldNames(AudienceTargetFieldEnum.ID, AudienceTargetFieldEnum.STATE)
                                            .withFullFieldNames()
                                            .withPage(new LimitOffsetMap().withLimit(Long.MAX_VALUE))
                                            .getBean()),
                                    e -> e.getFaultInfo().getErrorCode(),

                                    UnitsWithdrawalPageErrorTestData.PAGE_LIMIT_EXCEEDED_ERROR_CODE
                            ).run();

                            return port;
                        })

                ),

                dataProvider.buildDataSets(

                        UnitsWithdrawalWsdlErrorTestData.wsdlErrorExpected(),

                        getUnitsUsedLoginHeader((String clientLogin) -> {
                            AudienceTargetsPort port = api.userSteps.soapClientV5().audienceTargetsService(clientLogin);

                            errorExpected(
                                    ApiException.class,
                                    () -> port.get((GetRequest) new BadGetRequestMap()
                                            .withSelectionCriteria(new AudienceTargetSelectionCriteriaMap()
                                                    .withIds(0L))
                                            .withFullFieldNames()
                                            .getBean()),
                                    e -> e.getFaultInfo().getErrorCode(),

                                    UnitsWithdrawalWsdlErrorTestData.WSDL_ERROR_CODE
                            ).run();

                            return port;
                        })

                )
        );
    }

}
