package ru.yandex.autotests.direct.api.audiencetargets.units;

import java.util.function.Function;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.test.units.UnitsLogins;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTester;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTesterImpl;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.rules.ApiSteps.USE_OPERATOR_UNITS_FALSE;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-78024")
@Features(ApiFeatures.UNITS)
@Description("Проверка списания баллов и значения заголовка Units-Used-Login: у клиента недостаточно баллов")
@Tag(TagDictionary.TRUNK)
public class UnitsAudienceTargetsLowLimitTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final UnitsWithdrawalTester tester = new UnitsWithdrawalTesterImpl(api);

    private static final UnitsAudienceTargetsTestData dataProvider = new UnitsAudienceTargetsTestData(api);

    @Rule
    public Trashman trasher = new Trashman(api);

    private String operatorLogin = UnitsLogins.AGENCY;
    private String clientLogin = UnitsLogins.SUB_1;
    private Function<String, String> serviceCall = dataProvider.callAddWithHeaderCheck();

    @BeforeClass
    public static void init() {
        tester.init();
    }

    @Before
    public void reset() {
        tester.resetBuilder(operatorLogin, clientLogin)
                .baseLimit(1L)
                .useOperatorUnits(USE_OPERATOR_UNITS_FALSE)
                .execute();
    }

    @Test
    public void checkUnitsWithdrawal_shouldNotWithdrawUnits() {
        Runnable callWithNoHeaderCheck = () -> serviceCall.apply(clientLogin);
        // списаться ни с кого не должно, т.к. возникает ошибка: у клиента недостаточно баллов
        tester.testUnitsWithdrawal(callWithNoHeaderCheck, emptyList(), asList(operatorLogin, clientLogin));
    }

    @Test
    public void checkHeader_shouldReturnClientLogin() {
        // поскольку флаг Use-Operator-Units не передан, независимо от баланса/лимита
        // должны возвращать Units-Used-Login: <client_login>
        assertThat(serviceCall.apply(clientLogin), equalTo(clientLogin));
    }

}
