package ru.yandex.autotests.direct.api.audiencetargets.units;

import java.util.function.Function;

import com.yandex.direct.api.v5.audiencetargets.AddRequest;
import com.yandex.direct.api.v5.audiencetargets.AddResponse;
import com.yandex.direct.api.v5.audiencetargets.ApiException;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetsPort;
import com.yandex.direct.api.v5.audiencetargets.GetRequest;
import com.yandex.direct.api.v5.audiencetargets.GetResponse;

import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetAddItemMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataProvider;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataProviderImpl;

import static org.hamcrest.Matchers.empty;
import static ru.yandex.autotests.directapi.test.units.UnitsHeaderUtil.getUnitsUsedLoginHeader;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

class UnitsAudienceTargetsTestData {

    private final UnitsWithdrawalTestDataProvider dataProvider;

    private final ApiSteps api;

    UnitsAudienceTargetsTestData(ApiSteps api) {
        this.api = api;
        this.dataProvider = new UnitsWithdrawalTestDataProviderImpl();
    }

    Iterable<Object[]> provideData() {
        return dataProvider.buildDataSets(callGetWithHeaderCheck());
    }

    Function<String, String> callGetWithHeaderCheck() {
        final long invalidId = 0L;
        return getUnitsUsedLoginHeader((String clientLogin) -> {
            AudienceTargetsPort port = api.userSteps.soapClientV5().audienceTargetsService(clientLogin);
            try {
                GetResponse response = port.get((GetRequest) new GetRequestMap()
                        .withFieldNames(AudienceTargetFieldEnum.ID)
                        .withSelectionCriteria(
                                new AudienceTargetSelectionCriteriaMap().withIds(invalidId)).getBean());
                assumeThat("Получен пустой ответ", response.getAudienceTargets(), empty());
            } catch (ApiException ignore) {
                // игнорируем ошибку, чтобы можно было достать заголовки из ошибочного запроса
            }
            return port;
        });
    }

    Function<String, String> callAddWithHeaderCheck() {
        final long fakeId = 3L;
        return getUnitsUsedLoginHeader((String clientLogin) -> {
            AudienceTargetsPort port = api.userSteps.soapClientV5().audienceTargetsService(clientLogin);
            try {
                AddResponse response = port.add((AddRequest) new AddRequestMap().withAudienceTargets(new AudienceTargetAddItemMap()
                        .withAdGroupId(fakeId)
                        .withRetargetingListId(fakeId)
                        .withContextBid(MoneyCurrency.get(User.get(clientLogin).getCurrency())
                                .getLongMinPrice().longValue()))
                        .getBean());
                assumeThat("Получен пустой ответ", response.getAddResults(), empty());
            } catch (ApiException ignore) {
                // игнорируем ошибку, чтобы можно было достать заголовки из ошибочного запроса
            }

            return port;
        });
    }

}
