package ru.yandex.autotests.direct.api.audiencetargets.units;

import com.yandex.direct.api.v5.audiencetargets.ApiException;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetFieldEnum;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetsPort;
import com.yandex.direct.api.v5.audiencetargets.GetRequest;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.AudienceTargetSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.audiencetargets.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.test.units.UnitsHeaderUtil;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTester.UNITS_HEADER;
import static ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTester.UNITS_USED_LOGIN_HEADER;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(ApiFeatures.UNITS)
@Issue("https://st.yandex-team.ru/DIRECT-71906")
@Description("Проверка заголовка Units-Used-Login и списывание баллов в случае неправильного Client-Login")
public class UnitsBadClientLoginTest {
    private static final String OPERATOR = Logins.AGENCY_YE_DEFAULT;
    private static final int EXPECTED_ERROR_SPENT = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(OPERATOR);
    }

    @Test
    public void checkHeaderAndUnitsSpentOnInvalidClientLogin() {
        AudienceTargetsPort port = api.as(OPERATOR)
                .userSteps.soapClientV5().audienceTargetsService("---bad-login---");
        try {
            port.get((GetRequest) new GetRequestMap()
                    .withFieldNames(AudienceTargetFieldEnum.ID)
                    .withSelectionCriteria(
                            new AudienceTargetSelectionCriteriaMap().withIds(0L)).getBean());
            throw new AssertionError("Должна вернуться ошибка о неправильном Client-Login");
        } catch (ApiException ignore) {
            // игнорируем ошибку, чтобы можно было достать заголовки из ошибочного запроса
        }
        String usedLoginHeader = UnitsHeaderUtil.getHeader(port, UNITS_USED_LOGIN_HEADER);
        String unitsHeader = UnitsHeaderUtil.getHeader(port, UNITS_HEADER);
        int spent = Integer.parseInt(unitsHeader.split("/")[0]);

        assertThat("В заголовках правильно указан оператор", usedLoginHeader, equalTo(OPERATOR));
        assertThat("Должно списаться правильное кол-во баллов", spent, equalTo(EXPECTED_ERROR_SPENT));
    }
}
