package ru.yandex.autotests.direct.api.bidmodifiers.add;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 20.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Проверка предельного количества допустимых корректировок ставок в одном запросе")
public class AddBidModifiersAdjustmentLimitTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ANOTHER_2;

    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Test
    @Description("Количество корректировок ставок в запросе превышает максимальное")
    public void overlimitBidModifiersInOneRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(getBidModifiersMapArray(123456)),
                new Api5Error(9300, Api5ErrorDetails.BID_MODIFIERS_ADD_IN_REQUEST_LIMIT)
        );
    }

    @Test
    @Description("Количество демографических корректировок в запросе превышает максимальное")
    public void overlimitDemographicsAdjustmentsInOneRequestTest() {
        //DIRECT-43997
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withCampaignId(campaignID)
                        .withDemographicsAdjustment(getDemographicsAdjustmentMapArray())),
                MultiIdsExpectedResult.errors(new Notification(7001,
                        Api5ErrorDetails.BID_MODIFIERS_DEMOGRAPHICS_IN_REQUEST_LIMIT)));
    }

    @Test
    @Description("Количество ретаргетинговых корректировок в запросе превышает максимальное")
    public void overlimitRetargetingAdjustmentsInOneRequestTest() {
        //DIRECT-43995
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withCampaignId(campaignID)
                        .withRetargetingAdjustment(getRetargetingAdjustmentMapArray())),
                MultiIdsExpectedResult.errors(new Notification(7001,
                        Api5ErrorDetails.BID_MODIFIERS_RETARGETING_IN_REQUEST_LIMIT))
        );
    }

    private BidModifierAddMap[] getBidModifiersMapArray(long campaignID) {
        BidModifierAddMap[] bidModifiers = new BidModifierAddMap[AddRequestMap.BID_MODIFIERS_IN_REQUEST_LIMIT + 1];
        for (int i = 0; i < AddRequestMap.BID_MODIFIERS_IN_REQUEST_LIMIT + 1; i++) {
            bidModifiers[i] = new BidModifierAddMap()
                    .withMobileAdjustment(new MobileAdjustmentMap().defaultMobileAdjustment())
                    .withCampaignId(campaignID);
        }
        return bidModifiers;
    }

    private DemographicsAdjustmentMap[] getDemographicsAdjustmentMapArray() {
        DemographicsAdjustmentMap[] adjustmentArray =
                new DemographicsAdjustmentMap[BidModifierAddMap.DEMOGRAPHICS_ADJUSTMENT_IN_REQUEST_LIMIT + 1];
        for (int i = 0; i < BidModifierAddMap.DEMOGRAPHICS_ADJUSTMENT_IN_REQUEST_LIMIT + 1; i++) {
            adjustmentArray[i] = new DemographicsAdjustmentMap().defaultDemographicsAdjustment();
        }
        return adjustmentArray;
    }

    private RetargetingAdjustmentMap[] getRetargetingAdjustmentMapArray() {
        RetargetingAdjustmentMap[] adjustmentArray =
                new RetargetingAdjustmentMap[BidModifierAddMap.RETARGETING_ADJUSTMENT_IN_REQUEST_LIMIT + 1];
        for (int i = 0; i < BidModifierAddMap.RETARGETING_ADJUSTMENT_IN_REQUEST_LIMIT + 1; i++) {
            adjustmentArray[i] = new RetargetingAdjustmentMap()
                    .defaultRetargetingAdjustment()
                    .withRetargetingConditionId(Integer.parseInt(RandomStringUtils.randomNumeric(6)));
        }
        return adjustmentArray;
    }

    private SerpLayoutAdjustmentMap[] getSerpLayoutAdjustmentMapArray() {
        SerpLayoutAdjustmentMap[] adjustmentArray =
                new SerpLayoutAdjustmentMap[BidModifierAddMap.SERP_LAYOUT_ADJUSTMENT_IN_REQUEST_LIMIT + 1];
        for (int i = 0; i < BidModifierAddMap.SERP_LAYOUT_ADJUSTMENT_IN_REQUEST_LIMIT + 1; i++) {
            adjustmentArray[i] = new SerpLayoutAdjustmentMap().defaultSerpLayoutAdjustment();
        }
        return adjustmentArray;
    }
}
