package ru.yandex.autotests.direct.api.bidmodifiers.add;

import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.VideoAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 15.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Позитивные сценарии добавления корректировок ставок всех типов в одном запросе")
public class AddBidModifiersAdjustmentMultiTypesTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignID;
    private static Long groupID;
    private static Integer conditionId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
    }

    @Test
    @Description("Добавляем в одном запросе пять разных типов корректировок ставок - демографическую, " +
            "ретаргетинговую, региональную, мобильную и видео")
    public void addSeveralBidModifiersTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap().
                        withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .defaultDemographicsAdjustment())
                        .withAdGroupId(groupID),
                new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionId))
                        .withAdGroupId(groupID),
                new BidModifierAddMap()
                        .withRegionalAdjustment(new RegionalAdjustmentMap()
                                .defaultRegionalAdjustment())
                        .withCampaignId(campaignID),
                new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .defaultMobileAdjustment())
                        .withAdGroupId(groupID),
                new BidModifierAddMap()
                        .withVideoAdjustment(new VideoAdjustmentMap()
                                .defaultVideoAdjustment())
                        .withAdGroupId(groupID),
                new BidModifierAddMap()
                        .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                                .defaultSerpLayoutAdjustment())
                        .withCampaignId(campaignID));

        assertThat("добавлены корректировки ставок", bmIds, hasSize(6));
    }
}
