package ru.yandex.autotests.direct.api.bidmodifiers.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;

/**
 * Created by chicos on 20.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Проверка доступа агентства к группам клиента при добавлении корректировок ставок")
public class AddBidModifiersAgencyAccessGroupTest {
    private static final String singleClient = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static final String agency = BidModifiersLogins.AGENCY_4;
    private static final String subclient1 = BidModifiersLogins.SUBCLIENT_1;
    private static final String subclient2 = BidModifiersLogins.SUBCLIENT_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
    }

    @Test
    @Description("Добавим агентством корректировку ставок в группу созданную сублиентом")
    public void addBidModifierByAgencyTest() {
        Long campaignID = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .defaultMobileAdjustment())
                        .withAdGroupId(groupID)),
                MultiIdsExpectedResult.success());
    }

    @Test
    @Description("Добавим агентством корректировку ставок субклиенту, указав группу другого сублиента")
    public void anotherSubclientGroupTest() {
        //DIRECT-43991
        Long campaignID = api.as(subclient2).userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        Notification perlError = new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND);
        Notification javaError = new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND, groupID);
        MultiIdsExpectedResult perlExpectedResult = MultiIdsExpectedResult.errors(perlError);
        MultiIdsExpectedResult javaExpectedResult = MultiIdsExpectedResult.errors(javaError);

        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .defaultMobileAdjustment())
                        .withAdGroupId(groupID)),
                singletonList(perlExpectedResult), singletonList(javaExpectedResult));
    }

    @Test
    @Description("Добавим агентством корректировку ставок субклиенту, указав свою группу и группу другого сублиента")
    public void ownedGroupAndAnotherSubсlientGroupTest() {
        Long campaignID1 = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Long groupID1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID1);
        Long campaignID2 = api.as(subclient2).userSteps.campaignSteps().addDefaultTextCampaign(subclient2);
        Long groupID2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID2);

        Notification perlError = new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND);
        Notification javaError = new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND, groupID2);
        MultiIdsExpectedResult perlExpectedResult = MultiIdsExpectedResult.errors(perlError);
        MultiIdsExpectedResult javaExpectedResult = MultiIdsExpectedResult.errors(javaError);

        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                                .withMobileAdjustment(new MobileAdjustmentMap()
                                        .defaultMobileAdjustment())
                                .withAdGroupId(groupID1),
                        new BidModifierAddMap()
                                .withMobileAdjustment(new MobileAdjustmentMap()
                                        .defaultMobileAdjustment())
                                .withAdGroupId(groupID2)),
                asList(MultiIdsExpectedResult.success(), perlExpectedResult),
                asList(MultiIdsExpectedResult.success(), javaExpectedResult));
    }

    @Test
    @Description("Добавим агентством корректировку ставок субклиенту, указав группу самостоятельного клиента")
    public void nonOwnedGroupByAgencyTest() {
        Long campaignID = api.as(singleClient).userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);

        Notification perlError = new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND);
        Notification javaError = new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND, groupID);
        MultiIdsExpectedResult perlExpectedResult = MultiIdsExpectedResult.errors(perlError);
        MultiIdsExpectedResult javaExpectedResult = MultiIdsExpectedResult.errors(javaError);

        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .defaultMobileAdjustment())
                        .withAdGroupId(groupID)),
                singletonList(perlExpectedResult), singletonList(javaExpectedResult));
    }
}
