package ru.yandex.autotests.direct.api.bidmodifiers.add;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.VideoAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 22.07.15.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Stories(ApiStories.JSON5)
@RunWith(Parameterized.class)
@Description("Проверка валидации типов полей структуры BidModifiers")
public class AddBidModifiersFieldTypesNegativeTest {

    private static final String singleClient = BidModifiersLogins.SINGLE_CLIENT_ADD;
    private static long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(singleClient).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String fieldName;

    @Parameterized.Parameter(value = 2)
    public Object fieldValue;

    @Parameterized.Parameter(value = 3)
    public Api5Error expectedError;

    @Parameterized.Parameter(value = 4)
    public Api5Error alternativeError;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection fields() {
        Object[][] data = new Object[][]{
                {"Вещественное число в поле AdGroupId", BidModifierAddMap.ADGROUP_ID, 2.13f,
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                StringUtils.capitalize(BidModifierAddMap.ADGROUP_ID)),
                        new Api5Error(8000,
                                Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                                "BidModifiers." + StringUtils.capitalize(BidModifierAddMap.ADGROUP_ID))},
                {"JSON объект в поле AdGroupId", BidModifierAddMap.ADGROUP_ID, new JSONObject(),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                StringUtils.capitalize(BidModifierAddMap.ADGROUP_ID)),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                "BidModifiers." + StringUtils.capitalize(BidModifierAddMap.ADGROUP_ID))},
                {"Массив в поле AdGroupId", BidModifierAddMap.ADGROUP_ID, Arrays.asList(123456),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                StringUtils.capitalize(BidModifierAddMap.ADGROUP_ID)),
                        new Api5Error(8000,
                                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                "BidModifiers." + StringUtils.capitalize(BidModifierAddMap.ADGROUP_ID))},
                {"Массив в поле MobileAdjustment", BidModifierAddMap.MOBILE_ADJUSTMENT, Arrays.asList(new JsonObject()
                        .with(StringUtils.capitalize(MobileAdjustmentMap.BID_MODIFIER), BidModifierAddMap.DEFAULT_BID_MODIFIER)),
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                StringUtils.capitalize(BidModifierAddMap.MOBILE_ADJUSTMENT)),
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                "BidModifiers." + StringUtils.capitalize(BidModifierAddMap.MOBILE_ADJUSTMENT))},
                {"Не массив в поле RegionalAdjustments", BidModifierAddMap.REGIONAL_ADJUSTMENT, new JsonObject()
                        .with(StringUtils.capitalize(RegionalAdjustmentMap.BID_MODIFIER), BidModifierAddMap.DEFAULT_BID_MODIFIER),
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                                StringUtils.capitalize(BidModifierAddMap.REGIONAL_ADJUSTMENT)),
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                                "BidModifiers." + StringUtils.capitalize(BidModifierAddMap.REGIONAL_ADJUSTMENT))},
                {"Массив в поле VideoAdjustment", BidModifierAddMap.VIDEO_ADJUSTMENT, Arrays.asList(new JsonObject()
                        .with(StringUtils.capitalize(VideoAdjustmentMap.BID_MODIFIER), BidModifierAddMap.DEFAULT_BID_MODIFIER)),
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                StringUtils.capitalize(BidModifierAddMap.VIDEO_ADJUSTMENT)),
                        new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                "BidModifiers." + StringUtils.capitalize(BidModifierAddMap.VIDEO_ADJUSTMENT))},

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareGroup(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(singleClient);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
    }

    @Test
    public void invalidRequiredFieldTypeTest() {
        JsonObject addRequest = new JsonObject()
                .with(StringUtils.capitalize(AddRequestMap.BID_MODIFIERS), Arrays.asList(
                        new JsonObject()
                                .with(StringUtils.capitalize(BidModifierAddMap.MOBILE_ADJUSTMENT), new JsonObject()
                                        .with(StringUtils.capitalize(MobileAdjustmentMap.BID_MODIFIER), BidModifierAddMap.DEFAULT_BID_MODIFIER))
                                .with(StringUtils.capitalize(BidModifierAddMap.ADGROUP_ID), groupID)
                                .with(StringUtils.capitalize(fieldName), fieldValue)
                ));

        api.userSteps.bidModifiersSteps().shouldGetBidModifierErrorJsonOn(
                Action.ADD,
                addRequest,
                expectedError,
                alternativeError);
    }
}
