package ru.yandex.autotests.direct.api.bidmodifiers.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static freemarker.template.utility.Collections12.singletonList;

/**
 * Created by chicos on 16.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Использование некорректных идентификаторов кампании и группы")
@RunWith(Parameterized.class)
public class AddBidModifiersInvalidIDsTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;
    private static final String clientAnother = BidModifiersLogins.SINGLE_CLIENT_ANOTHER;

    private static Long campaignID;
    private static Long deletedCampaignID;
    private static Long nonOwnedCampaignID;

    private static Long groupID;
    private static Long deletedGroupID;
    private static Long nonOwnedGroupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public BidModifierAddMap bidModifier;

    @Parameterized.Parameter(2)
    public MultiIdsExpectedResult expectedResult;

    @Parameterized.Parameter(3)
    public MultiIdsExpectedResult alternativeResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        long UNEXISTING_AD_GROUP_ID = 123456789L;
        long UNEXISTING_CAMPAIGN_ID = 123456789L;

        prepareGroupsAndCampaigns();
        return Arrays.asList(new Object[][]{
                {"Несуществующая группа", new BidModifierAddMap().defaultBidModifier().withAdGroupId(
                        UNEXISTING_AD_GROUP_ID),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)),
                        MultiIdsExpectedResult.errors(
                                new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND, UNEXISTING_AD_GROUP_ID))},
                {"Удаленная группа", new BidModifierAddMap().defaultBidModifier().withAdGroupId(deletedGroupID),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)),
                        MultiIdsExpectedResult.errors(
                                new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND, deletedGroupID))},
                {"Чужая группа", new BidModifierAddMap().defaultBidModifier().withAdGroupId(nonOwnedGroupID),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)),
                        MultiIdsExpectedResult.errors(
                                new Notification(8800, Api5ErrorDetailsJava.GROUP_NOT_FOUND, nonOwnedGroupID))},
                {"Несуществующая кампания", new BidModifierAddMap().defaultBidModifier().withCampaignId(
                        UNEXISTING_CAMPAIGN_ID),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND,
                                UNEXISTING_CAMPAIGN_ID))},
                {"Удаленная кампания", new BidModifierAddMap().defaultBidModifier().withCampaignId(deletedCampaignID),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND,
                                deletedCampaignID))},
                {"Чужая кампания", new BidModifierAddMap().defaultBidModifier().withCampaignId(nonOwnedCampaignID),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetailsJava.CAMPAIGN_NOT_FOUND,
                                nonOwnedCampaignID))}
        });
    }

    private static void prepareGroupsAndCampaigns() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        nonOwnedCampaignID = api.as(clientAnother).userSteps.campaignSteps().addDefaultTextCampaign(clientAnother);
        nonOwnedGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(nonOwnedCampaignID);

        campaignID = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        deletedGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adGroupsSteps().deleteGroup(deletedGroupID);
        deletedCampaignID = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
        api.as(client).userSteps.campaignSteps().campaignsDelete(deletedCampaignID);
    }

    @Test
    public void bidModifierTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(bidModifier),
                singletonList(expectedResult), singletonList(alternativeResult));
    }
}
