package ru.yandex.autotests.direct.api.bidmodifiers.add;

import com.yandex.direct.api.v5.bidmodifiers.OperatingSystemTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DesktopAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SmartTvAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Проверка совместного добавления корректировок на устройстов: мобильной и десктопной")
public class AddBidModifiersMobileAndDesktopTest {
    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long campaignId;

    private Long adGroupId;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Before
    public void before() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
    }

    @Test
    public void addingMobileAndDesktopWithNonZeroAdjustmentsSimultaneouslyInCpmCampaignIsOk() {
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withDesktopAdjustment(
                                        new DesktopAdjustmentMap().defaultDesktopAdjustment()),
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withMobileAdjustment(
                                        new MobileAdjustmentMap().defaultMobileAdjustment())
                ),
                MultiIdsExpectedResult.success(),
                MultiIdsExpectedResult.success()
        );
    }

    @Test
    public void addingMobileAndDesktopAndSmartTVWithNonZeroAdjustmentsSimultaneouslyInCpmCampaignIsOk() {
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withDesktopAdjustment(
                                        new DesktopAdjustmentMap().defaultDesktopAdjustment()),
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withMobileAdjustment(
                                        new MobileAdjustmentMap().defaultMobileAdjustment()),
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withSmartTvAdjustment(
                                        new SmartTvAdjustmentMap().defaultSmartTvAdjustment())
                ),
                MultiIdsExpectedResult.success(),
                MultiIdsExpectedResult.success(),
                MultiIdsExpectedResult.success()
        );
    }

    @Test
    public void addingMobileWithOsTypeAndDesktopAndSmartTvWithZeroAdjustmentsSimultaneouslyInCpmCampaignIsOk() {
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withDesktopAdjustment(
                                        new DesktopAdjustmentMap()
                                                .withBidModifier(DesktopAdjustmentMap.DESKTOP_ADJUSTMENT_ABSOLUTE_MIN)),
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withMobileAdjustment(
                                        new MobileAdjustmentMap()
                                                .withOperatingSystemType(OperatingSystemTypeEnum.IOS)
                                                .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_ABSOLUTE_MIN)),
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withSmartTvAdjustment(
                                        new SmartTvAdjustmentMap()
                                                .withBidModifier(SmartTvAdjustmentMap.SMARTTV_ADJUSTMENT_ABSOLUTE_MIN))
                ),
                MultiIdsExpectedResult.success(),
                MultiIdsExpectedResult.success(),
                MultiIdsExpectedResult.success()
        );
    }

    @Test
    public void addingMobileAndDesktopWithZeroAdjustmentsSimultaneouslyInCpmCampaignIsOkMustCauseAnError() {
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withDesktopAdjustment(
                                        new DesktopAdjustmentMap()
                                                .withBidModifier(DesktopAdjustmentMap.DESKTOP_ADJUSTMENT_ABSOLUTE_MIN)),
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withMobileAdjustment(
                                        new MobileAdjustmentMap()
                                                .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_ABSOLUTE_MIN)),
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withSmartTvAdjustment(
                                        new SmartTvAdjustmentMap()
                                                .withBidModifier(SmartTvAdjustmentMap.SMARTTV_ADJUSTMENT_ABSOLUTE_MIN))
                ),
                MultiIdsExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.DEVICE_BID_MODIFIERS_ALL_ZEROS)),
                MultiIdsExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.DEVICE_BID_MODIFIERS_ALL_ZEROS)),
                MultiIdsExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.DEVICE_BID_MODIFIERS_ALL_ZEROS))
        );
    }

    @Test
    public void addingMobileAndDesktopWithZeroAdjustmentsSimultaneouslyInCpmCampaignIsOk() {
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withDesktopAdjustment(
                                        new DesktopAdjustmentMap()
                                                .withBidModifier(DesktopAdjustmentMap.DESKTOP_ADJUSTMENT_ABSOLUTE_MIN)),
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withMobileAdjustment(
                                        new MobileAdjustmentMap()
                                                .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_ABSOLUTE_MIN))
                ),
                MultiIdsExpectedResult.success(),
                MultiIdsExpectedResult.success()
        );
    }

    @Test
    public void addingMobileThenSmartTvThenDesktopWithZeroAdjustmentsInCpmCampaignMustCauseAnError() {
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withMobileAdjustment(
                                        new MobileAdjustmentMap()
                                                .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_ABSOLUTE_MIN))
                ),
                MultiIdsExpectedResult.success()
        );
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withSmartTvAdjustment(
                                        new SmartTvAdjustmentMap()
                                                .withBidModifier(SmartTvAdjustmentMap.SMARTTV_ADJUSTMENT_ABSOLUTE_MIN))
                ),
                MultiIdsExpectedResult.success()
        );
        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withAdGroupId(adGroupId)
                                .withDesktopAdjustment(
                                        new DesktopAdjustmentMap()
                                                .withBidModifier(DesktopAdjustmentMap.DESKTOP_ADJUSTMENT_ABSOLUTE_MIN))
                ),
                MultiIdsExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.DEVICE_BID_MODIFIERS_ALL_ZEROS))
        );
    }
}

