package ru.yandex.autotests.direct.api.bidmodifiers.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.general.GenderEnum;
import com.yandex.direct.api.v5.general.SerpLayoutEnum;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.VideoAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Проверка недоступных типов корректировок ставок для cpm_banner")
@RunWith(Parameterized.class)
public class AddBidModifiersNotSupportedForCpmBannerTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_RETARGETING_LISTS;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public BidModifierAddMap bidModifier;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        int videoBidModifier = (VideoAdjustmentMap.VIDEO_ADJUSTMENT_MAX -
                VideoAdjustmentMap.VIDEO_ADJUSTMENT_MIN) / 2;
        int regionalBidModifier = (RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX -
                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN) / 2;
        int mobileBidModifier = (MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX -
                MobileAdjustmentMap.MOBILE_ADJUSTMENT_MIN) / 2;
        int demographicsBidModifier = (DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MAX -
                DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MIN) / 2;
        int retargetingBidModifier = (RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MAX -
                RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MIN) / 2;
        int serpLayoutBidModifier = (SerpLayoutAdjustmentMap.SERP_LAYOUT_ADJUSTMENT_MAX -
                SerpLayoutAdjustmentMap.SERP_LAYOUT_ADJUSTMENT_MIN) / 2;

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        Long goalId =
                api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL).get(0);
        Long retargetingListsId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(goalId, LOGIN);

        return Arrays.asList(new Object[][]{
                {"Видео на кампанию", new BidModifierAddMap()
                        .withVideoAdjustment(new VideoAdjustmentMap()
                                .withBidModifier(videoBidModifier))
                        .withCampaignId(campaignId)
                },
                {"Видео на группу", new BidModifierAddMap()
                        .withVideoAdjustment(new VideoAdjustmentMap()
                                .withBidModifier(videoBidModifier))
                        .withAdGroupId(adGroupId)
                },
                {"Регион на кампанию", new BidModifierAddMap()
                        .withRegionalAdjustment(new RegionalAdjustmentMap()
                                .withBidModifier(regionalBidModifier)
                                .withRegionId(225))
                        .withCampaignId(campaignId)
                },
                {"Демография на кампанию", new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withBidModifier(demographicsBidModifier)
                                .withGender(GenderEnum.GENDER_FEMALE))
                        .withCampaignId(campaignId)
                },
                {"Мобильные на кампанию", new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .withBidModifier(mobileBidModifier))
                        .withCampaignId(campaignId)
                },
                {"Ретаргетинг на кампанию", new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withBidModifier(retargetingBidModifier)
                                .withRetargetingConditionId(retargetingListsId))
                        .withCampaignId(campaignId)
                },
                {"Позиция на кампанию", new BidModifierAddMap()
                        .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                                .withBidModifier(regionalBidModifier)
                                .withSerpLayout(SerpLayoutEnum.ALONE))
                        .withCampaignId(campaignId)
                },
        });
    }

    @Test
    public void bidModifierNotSupportedTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(bidModifier),
                MultiIdsExpectedResult.errors(new Notification(3500,
                        Api5ErrorDetails.ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED)));
    }
}
