package ru.yandex.autotests.direct.api.bidmodifiers.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.VideoAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;

/**
 * Created by semkagtn on 05.11.15.
 * https://st.yandex-team.ru/TESTIRT-7658
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Проверка недоступных типов корректировок ставок для кампании типа РМП")
@Issue("https://st.yandex-team.ru/DIRECT-45113")
@RunWith(Parameterized.class)
public class AddBidModifiersNotSupportedForMobileAppCampaignTest {
    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignID;
    private Long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public BidModifierAddMap bidModifier;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        int mobileBidModifier = (MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX -
                MobileAdjustmentMap.MOBILE_ADJUSTMENT_MIN) / 2;
        int videoBidModifier = (VideoAdjustmentMap.VIDEO_ADJUSTMENT_MAX -
                VideoAdjustmentMap.VIDEO_ADJUSTMENT_MIN) / 2;

        return Arrays.asList(new Object[][]{

                {"Мобильный", new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .withBidModifier(mobileBidModifier))
                },
                {"Видео", new BidModifierAddMap()
                        .withVideoAdjustment(new VideoAdjustmentMap()
                        .withBidModifier(videoBidModifier))
                },
        });
    }

    @BeforeClass
    public static void prepareCampaign() {
        campaignID = api.as(LOGIN).userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Before
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        groupID = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignID);
    }

    @Test
    public void bidModifierRangeTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(bidModifier.withAdGroupId(groupID)),
                singletonList(MultiIdsExpectedResult.errors(new Notification(3500,
                        Api5ErrorDetails.ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED))),
                singletonList(MultiIdsExpectedResult.errors(new Notification(3500,
                        Api5ErrorDetailsJava.ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED)))
        );
    }
}
