package ru.yandex.autotests.direct.api.bidmodifiers.add;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;

/**
 * Created by semkagtn on 05.11.15.
 * https://st.yandex-team.ru/TESTIRT-7658
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Проверка допустимого диапазона корректировок ставок для кампаний типа РМП")
@Issue("https://st.yandex-team.ru/DIRECT-45113")
@RunWith(Parameterized.class)
public class AddBidModifiersRangeForMobileAppCampaignTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignID;
    private Long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public BidModifierAddMap bidModifier;

    @Parameterized.Parameter(2)
    public MultiIdsExpectedResult expectedResult;

    @Parameterized.Parameter(3)
    public MultiIdsExpectedResult alternativeResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(LOGIN);

        return Arrays.asList(new Object[][]{

                {"Демографический - значение меньше минимального", new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_18_24)
                                .withBidModifier(DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER))},

                {"Демографический - минимальное значение", new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_18_24)
                                .withBidModifier(DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MIN)),
                        MultiIdsExpectedResult.success(), null},

                {"Демографический - максимальное значение", new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_18_24)
                                .withBidModifier(DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MAX)),
                        MultiIdsExpectedResult.success(), null},

                {"Демографический - значение больше максимального", new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_18_24)
                                .withBidModifier(DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MAX)), null},

                {"Ретаргетинговый - значение меньше минимального", new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionId)
                                .withBidModifier(RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER))},

                {"Ретаргетинговый - минимальное значение", new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionId)
                                .withBidModifier(RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MIN)),
                        MultiIdsExpectedResult.success(), null},

                {"Ретаргетинговый - максимальное значение", new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionId)
                                .withBidModifier(RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MAX)),
                        MultiIdsExpectedResult.success(), null},

                {"Ретаргетинговый - значение больше максимального", new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionId)
                                .withBidModifier(RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MAX)), null},
        });
    }

    @BeforeClass
    public static void prepareCampaign() {
        campaignID = api.as(LOGIN).userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Before
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        groupID = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignID);
    }

    @Test
    public void bidModifierRangeTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(bidModifier.withAdGroupId(groupID)),
                singletonList(expectedResult),
                Optional.ofNullable(alternativeResult).map(Collections::singletonList).orElse(null));
    }
}
