package ru.yandex.autotests.direct.api.bidmodifiers.add;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

import javax.annotation.Nullable;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.VideoAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;

/**
 * Created by chicos on 17.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Проверка допустимого диапазона корректировок ставок")
@RunWith(Parameterized.class)
public class AddBidModifiersRangeForNotMobileAppCampaignTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long textCampaignID;
    private static Long dynamicCampaignID;
    private Long groupID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public CampaignType type;

    @Parameterized.Parameter(2)
    public BidModifierAddMap bidModifier;

    @Parameterized.Parameter(3)
    public MultiIdsExpectedResult expectedResult;

    @Nullable
    @Parameterized.Parameter(4)
    public MultiIdsExpectedResult alternativeResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        return Arrays.asList(new Object[][]{
                //DIRECT-43962
                {"Мобильный - значение меньше минимального для текстовой кампании", CampaignType.TEXT, new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_ABSOLUTE_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER)), null},
                {"Мобильный - значение больше максимальногодля текстовой кампании", CampaignType.TEXT, new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX)), null},
                {"Демографический - значение меньше минимального для текстовой кампании", CampaignType.TEXT, new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_18_24)
                                .withBidModifier(DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER))},
                {"Демографический - значение больше максимального для текстовой кампании", CampaignType.TEXT, new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_18_24)
                                .withBidModifier(DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MAX)), null},
                {"Ретаргетинговый - значение меньше минимального для текстовой кампании", CampaignType.TEXT, new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionId)
                                .withBidModifier(RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER))},
                {"Ретаргетинговый - значение больше максимального для текстовой кампании", CampaignType.TEXT, new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionId)
                                .withBidModifier(RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MAX)), null},
                {"Видео - значение меньше минимального для текстовой кампании", CampaignType.TEXT, new BidModifierAddMap()
                        .withVideoAdjustment(new VideoAdjustmentMap()
                        .withBidModifier(VideoAdjustmentMap.VIDEO_ADJUSTMENT_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_LESS,
                                VideoAdjustmentMap.VIDEO_ADJUSTMENT_MIN)), null},
                {"Видео - значение больше максимального для текстовой кампании", CampaignType.TEXT, new BidModifierAddMap()
                        .withVideoAdjustment(new VideoAdjustmentMap()
                        .withBidModifier(VideoAdjustmentMap.VIDEO_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                VideoAdjustmentMap.VIDEO_ADJUSTMENT_MAX)), null},
                {"Мобильный - значение меньше минимального для динамической кампании", CampaignType.DYNAMIC, new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                        .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_ABSOLUTE_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER)), null},
                {"Мобильный - значение больше максимальногодля динамической кампании", CampaignType.DYNAMIC, new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                        .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX)), null},
                {"Демографический - значение меньше минимального для динамической кампании", CampaignType.DYNAMIC, new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                        .withAge(AgeRangeEnum.AGE_18_24)
                        .withBidModifier(DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER))},
                {"Демографический - значение больше максимального для динамической кампании", CampaignType.DYNAMIC, new BidModifierAddMap()
                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                        .withAge(AgeRangeEnum.AGE_18_24)
                        .withBidModifier(DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                DemographicsAdjustmentMap.DEMOGRAPHICS_ADJUSTMENT_MAX)), null},
                {"Ретаргетинговый - значение меньше минимального для динамической кампании", CampaignType.DYNAMIC, new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withRetargetingConditionId(conditionId)
                        .withBidModifier(RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MIN - 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetailsJava.COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER))},
                {"Ретаргетинговый - значение больше максимального для динамической кампании", CampaignType.DYNAMIC, new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withRetargetingConditionId(conditionId)
                        .withBidModifier(RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MAX + 1)),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RetargetingAdjustmentMap.RETARGETING_ADJUSTMENT_MAX)), null},
        });
    }

    @BeforeClass
    public static void prepareCampaign() {
        textCampaignID = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
        dynamicCampaignID = api.as(client).userSteps.campaignSteps().addDefaultDynamicTextCampaign(client);
    }

    @Before
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        if(type == CampaignType.TEXT){
            groupID = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignID);
        } else if(type == CampaignType.DYNAMIC){
            groupID = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicCampaignID);
        }
    }

    @Test
    public void bidModifierRangeTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(bidModifier.withAdGroupId(groupID)),
                singletonList(expectedResult),
                Optional.ofNullable(alternativeResult).map(Collections::singletonList).orElse(null));
    }
}
