package ru.yandex.autotests.direct.api.bidmodifiers.add;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.utils.AccessRightsErrorHelper.checkCatchingJavaAccessError;

@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Добавление корректировок ставок от имени внутренних ролей - негативные тесты")
public class AddBidModifiersRolesAccessNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);
    private LogSteps log = LogSteps.getLogger(this.getClass());

    public long prepareGroup(String bidModifierCreator, String groupCreator, String client) {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(bidModifierCreator);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(groupCreator);

        log.info("Создадим кампанию и группу от имени " + groupCreator);
        api.as(groupCreator);
        Long campaignID = api.userSteps.campaignStepsV5().addDefaultTextCampaign(client);
        return api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, client);
    }

    @Test
    public void addBidModifierRolesSubclientTest() {
        String groupCreator = BidModifiersLogins.AGENCY_1;
        String bidModifierCreator = BidModifiersLogins.SUBCLIENT;
        String client = BidModifiersLogins.SUBCLIENT;

        long groupId = prepareGroup(bidModifierCreator, groupCreator, client);

        checkCatchingJavaAccessError(new Api5Error(54), () ->
                api.as(bidModifierCreator).userSteps.bidModifiersSteps().shouldGetResultOn(
                        client,
                        Action.ADD,
                        new AddRequestMap().withBidModifiers(
                                new BidModifierAddMap()
                                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                                .defaultDemographicsAdjustment())
                                        .withAdGroupId(groupId)
                        ),
                        MultiIdsExpectedResult.errors(new Notification(54,
                                Api5ErrorDetails.NO_RIGHTS_TO_WRITE))));
    }
}
