package ru.yandex.autotests.direct.api.bidmodifiers.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.utils.AccessRightsErrorHelper.checkCatchingJavaAccessError;

/**
 * Created by chicos on 20.07.15
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Добавление корректировок ставок от имени внутренних ролей")
@RunWith(Parameterized.class)
public class AddBidModifiersRolesAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String groupCreator;

    @Parameterized.Parameter(1)
    public String bidModifierCreator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public MultiIdsExpectedResult expectedResult;

    @Parameterized.Parameter(4)
    public Api5Error error;

    @Parameterized.Parameters(name = "group = {0}, modifier = {1}, client = {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, BidModifiersLogins.SERV_CLIENT,
                        MultiIdsExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, Logins.PLACER, BidModifiersLogins.SINGLE_CLIENT_ADD,
                        MultiIdsExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, BidModifiersLogins.SINGLE_CLIENT_ADD,
                        MultiIdsExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_ADD,
                        MultiIdsExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_ADD, BidModifiersLogins.SINGLE_CLIENT_ADD,
                        MultiIdsExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, BidModifiersLogins.SINGLE_CLIENT_REP, BidModifiersLogins.SINGLE_CLIENT,
                        MultiIdsExpectedResult.success(), null},
                {BidModifiersLogins.AGENCY_1, BidModifiersLogins.AGENCY_1, BidModifiersLogins.SUBCLIENT,
                        MultiIdsExpectedResult.success(), null},
                {BidModifiersLogins.AGENCY_REP, BidModifiersLogins.AGENCY_REP, BidModifiersLogins.SUBCLIENT,
                        MultiIdsExpectedResult.success(), null}
        });
    }

    private long groupID;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(bidModifierCreator);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(groupCreator);

        log.info("Создадим кампанию и группу от имени " + groupCreator);
        api.as(groupCreator);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, client);
    }

    @Test
    public void addBidModifierRolesTest() {
        checkCatchingJavaAccessError(
                error,
                () -> api.as(bidModifierCreator).userSteps.bidModifiersSteps().shouldGetResultOn(
                        client,
                        Action.ADD,
                        new AddRequestMap().withBidModifiers(
                                new BidModifierAddMap()
                                        .withDemographicsAdjustment(new DemographicsAdjustmentMap()
                                                .defaultDemographicsAdjustment())
                                        .withAdGroupId(groupID)
                        ),
                        expectedResult
                )
        );
    }
}
