package ru.yandex.autotests.direct.api.bidmodifiers.add.demographics;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.Ignore;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Created by chicos on 15.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Негативные сценарии добавления демографических корректировок ставок")
public class AddBidModifiersDemographicsNegativeTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;
    private static Long adGroupId;
    private static Long campaignId1;
    private static Long adGroupId1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1);
    }

    @Test
    @Description("Отсутствие полей Age и Gender, одно из которых должно обязательно присутствовать")
    public void noAgeAndGenderTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap().withDefaultBidModifier())
                        .withCampaignId(campaignId.longValue())),
                MultiIdsExpectedResult.errors(new Notification(5008, Api5ErrorDetails.BID_MODIFIERS_AGE_OR_GENDER_REQUIRED)));
    }

    @Test
    @Description("Идентичные демографические корректировки ставок в одном запросе")
    public void identicalAdjustmentsInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap().defaultDemographicsAdjustment(),
                        new DemographicsAdjustmentMap().defaultDemographicsAdjustment())
                        .withCampaignId(campaignId.longValue())),
                MultiIdsExpectedResult.errors(new Notification(6000, Api5ErrorDetails.BID_MODIFIER_ADJUSTMENT_INTERSECTION)));
    }

    @Test
    @Description("Пересекающиеся демографические корректировки ставок в одном запросе")
    public void Age45AndAge45_54InRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_45)
                                .withBidModifier(120),
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_45_54)
                                .withBidModifier(120))
                        .withCampaignId(campaignId)),
                MultiIdsExpectedResult.errors(new Notification(6000, Api5ErrorDetails.BID_MODIFIER_ADJUSTMENT_INTERSECTION)));
    }

    @Test
    @Description("Пересекающиеся демографические корректировки ставок в одном запросе")
    public void Age45AndAge55InRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_45)
                                .withBidModifier(120),
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_55)
                                .withBidModifier(120))
                        .withAdGroupId(adGroupId)),
                MultiIdsExpectedResult.errors(new Notification(6000, Api5ErrorDetails.BID_MODIFIER_ADJUSTMENT_INTERSECTION)));
    }

    @Test
    @Description("Пересекающиеся демографические корректировки ставок в двух запросах")
    public void Age45AndAge45_54InTwoRequestsTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_45)
                                .withBidModifier(120))
                        .withCampaignId(campaignId1)),
                MultiIdsExpectedResult.success());
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_45_54)
                                .withBidModifier(120))
                        .withCampaignId(campaignId1)),
                MultiIdsExpectedResult.errors(new Notification(6000, Api5ErrorDetails.BID_MODIFIER_ADJUSTMENT_INTERSECTION)));

    }

    @Test
    @Description("Пересекающиеся демографические корректировки ставок в двух запросах")
    public void Age45AndAge55InTwoRequestsTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_45)
                                .withBidModifier(120))
                        .withAdGroupId(adGroupId1)),
                MultiIdsExpectedResult.success());
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_55)
                                .withBidModifier(120))
                        .withAdGroupId(adGroupId1)),
                MultiIdsExpectedResult.errors(new Notification(6000, Api5ErrorDetails.BID_MODIFIER_ADJUSTMENT_INTERSECTION)));

    }

    @Test
    @Description("Добавляем демографическую корректировку ставок пересекающуюся с ранее добавленной")
    public void adjustmentIntersectionTest() {
        api.userSteps.bidModifiersSteps().addBidModifierDemographicsToCampaign(campaignId.intValue());
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withDemographicsAdjustment(
                        new DemographicsAdjustmentMap()
                                .withAge(AgeRangeEnum.AGE_18_24)
                                .withBidModifier(120))
                        .withCampaignId(campaignId)),
                MultiIdsExpectedResult.errors(new Notification(6000, Api5ErrorDetails.BID_MODIFIER_ADJUSTMENT_INTERSECTION)));
    }
}
