package ru.yandex.autotests.direct.api.bidmodifiers.add.demographics;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.general.AgeRangeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentGetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.CompareStrategy;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 01.02.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8037
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Установка демографического типа корректировки ставок для кампании типа ДТО")
public class AddDemographicBidModifiersForDynamicTextCampaignTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long groupId;
    private AgeRangeEnum ageRange = AgeRangeEnum.AGE_0_17;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        groupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
    }

    @Test
    public void addDemographicBidModifierForDTOCampaign() {
        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .defaultBidModifier()
                        .withAdGroupId(groupId)
                        .withDemographicsAdjustment(
                                new DemographicsAdjustmentMap()
                                        .withDefaultBidModifier()
                                        .withAge(ageRange)
                        )
        );
        List<BidModifierGetItem> result = api.userSteps.bidModifiersSteps().bidModifiersGetByAdGroupId(groupId);

        CompareStrategy strategy = DefaultCompareStrategies.onlyExpectedFields();
        assertThat("вернулась верная корректировка", result, beanDiffer(
                Arrays.asList(
                    (BidModifierGetItem) new BidModifierGetItemMap()
                            .withDemographicsAdjustment(
                                    new DemographicsAdjustmentGetMap()
                                            .withDefaultBidModifier()
                            ).getBean()))
                .useCompareStrategy(strategy)
        );
    }
}
