package ru.yandex.autotests.direct.api.bidmodifiers.add.desktop;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DesktopAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Негативные сценарии добавления десктопных корректировок")
public class AddBidModifiersDesktopNegativeTest {
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовим данные для теста")
    public void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void addingDesktopBidModifierToCampaignLevelInCpmMustCauseAnError() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign(CLIENT);

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withDesktopAdjustment(new DesktopAdjustmentMap().defaultDesktopAdjustment())
                        .withCampaignId(campaignId)),
                MultiIdsExpectedResult.errors(new Notification(3500,
                        Api5ErrorDetails.ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED)));
    }

    @Test
    public void addingDesktopBidModifierToAdGroupInArchivedCampaignMustCauseAnError() {
        Long archivedCampaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(archivedCampaignId);
        api.userSteps.campaignSteps().campaignsSuspend(archivedCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(archivedCampaignId);

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withDesktopAdjustment(new DesktopAdjustmentMap().defaultDesktopAdjustment())
                        .withAdGroupId(adGroupId)),
                MultiIdsExpectedResult.errors(new Notification(8300,
                        Api5ErrorDetailsJava.UNABLE_UPDATE_ARCHIVED_CAMPAGN))
        );
    }
}
