package ru.yandex.autotests.direct.api.bidmodifiers.add.income_grade;

import com.yandex.direct.api.v5.general.IncomeGradeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.IncomeGradeAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Ошибки при установка корректировки ставок на доход")
public class AddIncomeGradeBidModifiersNegativeTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long groupId;

    private Long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        groupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
    }

    @Test
    public void doNotAllowCreateDuplicateBidModifierForGroup() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withAdGroupId(groupId)
                        .withIncomeGradeAdjustments(INCOME_GRADE_ADJUSTMENT_MAP_1, INCOME_GRADE_ADJUSTMENT_MAP_2)),
                MultiIdsExpectedResult.errors(new Notification(6000).withDetails("Условия в корректировках " +
                        "пересекаются"))
        );
    }

    @Test
    public void doNotAllowCreateDuplicateBidModifierForCampaign() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withCampaignId(campaignId)
                        .withIncomeGradeAdjustments(INCOME_GRADE_ADJUSTMENT_MAP_1, INCOME_GRADE_ADJUSTMENT_MAP_2)),
                MultiIdsExpectedResult.errors(new Notification(6000).withDetails("Условия в корректировках " +
                        "пересекаются"))
        );
    }

    @Test
    public void doNotAllowCreateBidModifierForUnsupportedTypeCampaign() {
        Long cpmCampaign = api.as(LOGIN).userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withCampaignId(cpmCampaign)
                        .withIncomeGradeAdjustments(INCOME_GRADE_ADJUSTMENT_MAP_1)),
                MultiIdsExpectedResult.errors(new Notification(3500,
                        Api5ErrorDetails.ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED))
        );
    }

    private final IncomeGradeAdjustmentMap INCOME_GRADE_ADJUSTMENT_MAP_1 =
            new IncomeGradeAdjustmentMap()
                    .withBidModifier(300)
                    .withGrade(IncomeGradeEnum.HIGH);

    private final IncomeGradeAdjustmentMap INCOME_GRADE_ADJUSTMENT_MAP_2 =
            new IncomeGradeAdjustmentMap()
                    .withBidModifier(200)
                    .withGrade(IncomeGradeEnum.HIGH);
}
