package ru.yandex.autotests.direct.api.bidmodifiers.add.income_grade;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import com.yandex.direct.api.v5.general.IncomeGradeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.IncomeGradeAdjustmentGetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.IncomeGradeAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.CompareStrategy;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Установка корректировки ставок на доход")
public class AddIncomeGradeBidModifiersTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long groupId;

    private Long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        groupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
    }

    @Test
    public void addIncomeGradeBidModifierForGroup() {
        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withAdGroupId(groupId)
                        .withIncomeGradeAdjustments(INCOME_GRADE_ADJUSTMENT_MAP_1, INCOME_GRADE_ADJUSTMENT_MAP_2)
        );
        List<BidModifierGetItem> result = api.userSteps.bidModifiersSteps().bidModifiersGetByAdGroupId(groupId);

        CompareStrategy strategy = DefaultCompareStrategies.onlyExpectedFields();
        assertThat("вернулась верная корректировка", result, beanDiffer(
                Arrays.asList(
                        (BidModifierGetItem) new BidModifierGetItemMap()
                                .withIncomeGradeAdjustment(EXPECTED_INCOME_GRADE_ADJUSTMENT_1).getBean(),
                        (BidModifierGetItem) new BidModifierGetItemMap()
                                .withIncomeGradeAdjustment(EXPECTED_INCOME_GRADE_ADJUSTMENT_2).getBean()))
                .useCompareStrategy(strategy)
        );
    }

    @Test
    public void addIncomeGradeBidModifierForCampaign() {
        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withCampaignId(campaignId)
                        .withIncomeGradeAdjustments(INCOME_GRADE_ADJUSTMENT_MAP_1, INCOME_GRADE_ADJUSTMENT_MAP_2)
        );
        List<BidModifierGetItem> result = api.userSteps.bidModifiersSteps().bidModifiersGetByCampaignId(campaignId);

        CompareStrategy strategy = DefaultCompareStrategies.onlyExpectedFields();
        assertThat("вернулась верная корректировка", result, beanDiffer(
                Arrays.asList(
                        (BidModifierGetItem) new BidModifierGetItemMap()
                                .withIncomeGradeAdjustment(EXPECTED_INCOME_GRADE_ADJUSTMENT_1).getBean(),
                        (BidModifierGetItem) new BidModifierGetItemMap()
                                .withIncomeGradeAdjustment(EXPECTED_INCOME_GRADE_ADJUSTMENT_2).getBean()))
                .useCompareStrategy(strategy)
        );
    }

    private final IncomeGradeAdjustmentMap INCOME_GRADE_ADJUSTMENT_MAP_1 =
            new IncomeGradeAdjustmentMap()
                    .withDefaultBidModifier()
                    .withGrade(IncomeGradeEnum.HIGH);

    private final IncomeGradeAdjustmentMap INCOME_GRADE_ADJUSTMENT_MAP_2 =
            new IncomeGradeAdjustmentMap()
                    .withDefaultBidModifier()
                    .withGrade(IncomeGradeEnum.VERY_HIGH);

    private final IncomeGradeAdjustmentGetMap EXPECTED_INCOME_GRADE_ADJUSTMENT_1 =
            new IncomeGradeAdjustmentGetMap()
                    .withDefaultBidModifier()
                    .withGrade(IncomeGradeEnum.HIGH);

    private final IncomeGradeAdjustmentGetMap EXPECTED_INCOME_GRADE_ADJUSTMENT_2 =
            new IncomeGradeAdjustmentGetMap()
                    .withDefaultBidModifier()
                    .withGrade(IncomeGradeEnum.VERY_HIGH);
}
