package ru.yandex.autotests.direct.api.bidmodifiers.add.mobile;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;

/**
 * Created by chicos on 16.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Негативные сценарии добавления мобильных корректировок ставок")
public class AddBidModifiersMobileNegativeTest {
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignArchived;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Step("Подготовим данные для теста")
    public void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignArchived = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        api.userSteps.campaignSteps().campaignsSuspend(campaignArchived);
        api.userSteps.campaignSteps().campaignsArchive(campaignArchived);
    }

    @Test
    public void addingMobileIosBidModifierToCampaignLevelInCpmMustCauseAnError() {
        Long cpmCampaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign(CLIENT);

        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap().defaultMobileIosAdjustment())
                        .withCampaignId(cpmCampaignId)),
                MultiIdsExpectedResult.errors(new Notification(3500,
                        Api5ErrorDetails.ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED)));
    }

    @Test
    public void addingIosMobileBidModifierWithTooLargeAdjustmentToCpmCampaignMustCauseAnError() {
        Long cpmCampaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(cpmCampaignId);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withMobileAdjustment(
                                new MobileAdjustmentMap().defaultMobileIosAdjustment()
                                        .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX + 1))
                        .withAdGroupId(adGroupId)),
                MultiIdsExpectedResult.errors(new Notification(5005,
                        Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                        MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX))
        );
    }

    @Test
    public void addingMobileBidModifierWithoutOsButWithTooLargeAdjustmentToCpcCampaignMustCauseAnError() {
        Long cpcCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(cpcCampaignId);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withMobileAdjustment(
                                new MobileAdjustmentMap().defaultMobileAdjustment()
                                        .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX + 1))
                        .withAdGroupId(adGroupId)),
                MultiIdsExpectedResult.errors(new Notification(5005,
                        Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                        MobileAdjustmentMap.MOBILE_ADJUSTMENT_MAX))
        );
    }

    @Test
    public void addWithoutOsThenWithOsMustCauseAnError() {
        Long cpmCampaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign(CLIENT);
        Long cpmAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(cpmCampaignId);

        api.userSteps.bidModifiersSteps().shouldGetResultOnAdd(
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withAdGroupId(cpmAdGroupId)
                        .withMobileAdjustment(new MobileAdjustmentMap().defaultMobileAdjustment())),
                MultiIdsExpectedResult.success()
        );
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withAdGroupId(cpmAdGroupId)
                        .withMobileAdjustment(new MobileAdjustmentMap().defaultMobileIosAdjustment())),
                MultiIdsExpectedResult.errors(new Notification(9801,
                        Api5ErrorDetailsJava.OBJECT_EXISTS, BidModifierAddMap.MOBILE_ADJUSTMENT)));
    }

    @Test
    @Description("Попробуем добавить корректировку ставки в архивную кампанию")
    public void archivedCampaignTest() {
        //DIRECT-44302
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap().defaultMobileAdjustment())
                        .withCampaignId(campaignArchived)),
                singletonList(MultiIdsExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN))),
                singletonList(MultiIdsExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetailsJava.UNABLE_UPDATE_ARCHIVED_CAMPAGN))));
    }
}
