package ru.yandex.autotests.direct.api.bidmodifiers.add.mobile;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.startsWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 15.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Позитивные сценарии добавления мобильных корректировок ставок")
public class AddBidModifiersMobileTest {
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;
    private static Long groupId;

    private static final String ID_PREFIX = "10";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        groupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void bidModifierToGroupTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withMobileAdjustment(new MobileAdjustmentMap()
                        .defaultMobileAdjustment())
                .withAdGroupId(groupId));

        assertThat("добавлена мобильная корректировка ставок", bmIds, hasSize(1));
    }

    @Test
    public void bidModifierToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withMobileAdjustment(new MobileAdjustmentMap()
                        .defaultMobileAdjustment())
                .withCampaignId(campaignId));

        assertThat("добавлена мобильная корректировка ставок", bmIds, hasSize(1));
    }

    @Test
    @Description("Идентификатор мобильной корректировки ставки должен начинаться с префикса - " + ID_PREFIX)
    public void complexIdentificatorMobileTest() {
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withMobileAdjustment(new MobileAdjustmentMap()
                        .withBidModifier(112))
                .withAdGroupId(groupID));
        assumeThat("добавлена мобильная корректировка ставки", bmIds, hasSize(1));

        assertThat("идентификатор мобильной корректировки ставки начинается с корректного префикса",
                String.valueOf(bmIds.get(0)), startsWith(ID_PREFIX));
    }

    @Test
    public void addingMobileBidModifierWithoutOsButWithZeroAdjustmentToCpcCampaign() {
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withMobileAdjustment(
                        new MobileAdjustmentMap().defaultMobileAdjustment()
                                .withBidModifier(MobileAdjustmentMap.MOBILE_ADJUSTMENT_ABSOLUTE_MIN))
                .withAdGroupId(adGroupId));

        assertThat("добавлена мобильная корректировка ставок c минимальным коэффициентом", bmIds, hasSize(1));
    }

}
