package ru.yandex.autotests.direct.api.bidmodifiers.add.regional;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/DIRECT-64099
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Проверка допустимого диапазона корректировок на регион ставок для кампаний разного типа")
@Issue("https://st.yandex-team.ru/DIRECT-63882")
@RunWith(Parameterized.class)
public class AddBidModifiersRangeForRegionalAdjustmentsTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;
    private static Long textCampaignId;
    private static Long dynamicCampaignId;
    private static Long mobileCampaignId;
    private static Integer regionId1 = RegionIDValues.SPB.getId();
    private static Integer regionId2 = RegionIDValues.MOSCOW.getId();
    private static Integer regionId3 = RegionIDValues.BELARUS.getId();
    private static Integer regionId4 = RegionIDValues.GERMANY.getId();
    private static Integer regionId5 = RegionIDValues.UKRAINE.getId();
    private static Integer regionId6 = RegionIDValues.SEVASTOPOL.getId();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long campaignId;

    @Parameterized.Parameter(2)
    public RegionalAdjustmentMap regionalAdjustmentMap;

    @Parameterized.Parameter(3)
    public MultiIdsExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        dynamicCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        mobileCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        return Arrays.asList(new Object[][]{
                {"Региональный - значение меньше минимального для мобильной кампании", mobileCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultRegionId()
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN - 1),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_LESS,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN))},
                {"Региональный - минимальное значение для мобильной кампании", mobileCampaignId,
                        new RegionalAdjustmentMap()
                                .withRegionId(regionId1)
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN),
                        MultiIdsExpectedResult.success()},
                {"Региональный - максимальное значение для мобильной кампании", mobileCampaignId,
                        new RegionalAdjustmentMap()
                                .withRegionId(regionId2)
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX),
                        MultiIdsExpectedResult.success()},
                {"Региональный - значение больше максимального для мобильной кампании", mobileCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultRegionId()
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX + 1),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX))},

                {"Региональный - значение меньше минимального для динамической кампании", dynamicCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultRegionId()
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN - 1),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_LESS,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN ))},
                {"Региональный - минимальное значение для динамической кампании", dynamicCampaignId,
                        new RegionalAdjustmentMap()
                                .withRegionId(regionId3)
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN),
                        MultiIdsExpectedResult.success()},
                {"Региональный - максимальное значение для динамической кампании", dynamicCampaignId,
                        new RegionalAdjustmentMap()
                                .withRegionId(regionId4)
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX),
                        MultiIdsExpectedResult.success()},
                {"Региональный - значение больше максимального для динамической кампании", dynamicCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultRegionId()
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX + 1),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX))},

                {"Региональный - значение меньше минимального для текстовой кампании", textCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultRegionId()
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN - 1),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_LESS,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN ))},
                {"Региональный - минимальное значение для текстовой кампании", textCampaignId,
                        new RegionalAdjustmentMap()
                                .withRegionId(regionId5)
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MIN),
                        MultiIdsExpectedResult.success()},
                {"Региональный - максимальное значение для текстовой кампании", textCampaignId,
                        new RegionalAdjustmentMap()
                                .withRegionId(regionId6)
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX),
                        MultiIdsExpectedResult.success()},
                {"Региональный - значение больше максимального для текстовой кампании", textCampaignId,
                        new RegionalAdjustmentMap()
                                .withDefaultRegionId()
                                .withBidModifier(RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX + 1),
                        MultiIdsExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.BID_MODIFIER_SHOULD_BE_NOT_MORE,
                                RegionalAdjustmentMap.REGIONAL_ADJUSTMENT_MAX))},

        });
    }

    @BeforeClass
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void bidModifierRangeTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(
                        new BidModifierAddMap()
                                .withRegionalAdjustment(regionalAdjustmentMap)
                                .withCampaignId(campaignId)),
                expectedResult);
    }
}
