package ru.yandex.autotests.direct.api.bidmodifiers.add.regional;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RegionalAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.startsWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-64099
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-63882")
@Description("Позитивные сценарии добавления корректировок ставок на регион")
public class AddBidModifiersRegionalTest {
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignID;
    private final String ID_PREFIX = "13";
    private final Integer regionId1 = RegionIDValues.SPB.getId();
    private final Integer regionId2 = RegionIDValues.MOSCOW.getId();
    private final Integer regionId3 = RegionIDValues.BELARUS.getId();
    private final Integer regionId4 = RegionIDValues.GERMANY.getId();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareConditions() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
    }

    @Test
    @Description("Добавим корректировку ставки для кампании")
    public void bidModifierToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRegionalAdjustment(new RegionalAdjustmentMap()
                        .defaultRegionalAdjustment()
                        .withRegionId(regionId1))
                .withCampaignId(campaignID));

        assertThat("добавлена корректировка ставки", bmIds, hasSize(1));
    }

    @Test
    @Description("Добавим несколько корректировок ставки для кампании")
    public void multipleRegionalAdjustmentToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRegionalAdjustment(new RegionalAdjustmentMap()
                                .defaultRegionalAdjustment()
                                .withRegionId(regionId2),
                        new RegionalAdjustmentMap()
                                .defaultRegionalAdjustment()
                                .withRegionId(regionId3))
                .withCampaignId(campaignID));

        assertThat("добавлены корректировки ставок", bmIds, hasSize(2));
    }

    @Test
    @Description("Идентификатор корректировки ставки по региону должен начинаться с префикса - " + ID_PREFIX)
    public void complexIdentificatorRegionalTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRegionalAdjustment(new RegionalAdjustmentMap()
                        .withDefaultBidModifier()
                        .withRegionId(regionId4))
                .withCampaignId(campaignID));
        assumeThat("добавлена корректировка ставки", bmIds, hasSize(1));
        assertThat("идентификатор корректировки начинается с корректного префикса",
                String.valueOf(bmIds.get(0)), startsWith(ID_PREFIX));
    }

}
