package ru.yandex.autotests.direct.api.bidmodifiers.add.retargeting;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 20.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Проверка доступа агентства к кампаниям клиента при добавлении корректировок ставок")
public class AddBidModifiersRetargetingConditionAgencyAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String singleClient = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static final String agency = BidModifiersLogins.AGENCY_4;
    private static final String subclient1 = BidModifiersLogins.SUBCLIENT_1;
    private static final String subclient2 = BidModifiersLogins.SUBCLIENT_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(singleClient);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
    }

    @Test
    @Description("Добавим агентством ретаргетинговую корректировку используя условие ретаргетинга созданное субклиентом")
    public void addBidModifierByAgencyTest() {
        //DIRECT-43995
        Long campaignID = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(subclient1);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionId)
                                .withDefaultBidModifier())
                        .withCampaignId(campaignID)),
                MultiIdsExpectedResult.success());
    }

    @Test
    @Description("Добавим агентством ретаргетинговую корректировку субклиенту, указав условие ретаргетинга другого сублиента")
    public void anotherSubсlientRetargetingConditionTest() {
        Integer conditionAnother = api.as(subclient2).userSteps.retargetingSteps().addRandomRetargetingCondition(subclient2);
        Long campaignID = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionAnother)
                                .withDefaultBidModifier())
                        .withCampaignId(campaignID)),
                MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.RETARGETING_CONDITION_NOT_FOUND, conditionAnother)));
    }

    @Test
    @Description("Добавим агентством ретаргетинговую корректировку ставок субклиенту, " +
            "указав свою условие ретаргетинга и условие ретаргетинга другого сублиента")
    public void ownedConditionAndAnotherSubсlientConditionTest() {
        log.info("Добавим условие ретаргетинга другому субклиенту");
        Integer conditionAnother = api.as(subclient2).userSteps.retargetingSteps().addRandomRetargetingCondition(subclient2);
        log.info("Создадим кампанию и собственное условие ретаргетинга");
        Long campaignID = api.as(subclient1).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(subclient1);

        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                        .withRetargetingConditionId(conditionId)
                                        .withDefaultBidModifier(),
                                new RetargetingAdjustmentMap()
                                        .withRetargetingConditionId(conditionAnother)
                                        .withDefaultBidModifier())
                        .withCampaignId(campaignID)),
                MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.RETARGETING_CONDITION_NOT_FOUND, conditionAnother)));
    }

    @Test
    @Description("Добавим агентством ретаргетинговую корректировку ставок субклиенту, указав условие ретаргетинга самостоятельного клиента")
    public void nonOwnedConditionByAgencyTest() {
        Long campaignID = api.as(agency).userSteps.campaignSteps().addDefaultTextCampaign(subclient1);
        Integer conditionAnother = api.as(singleClient).userSteps.retargetingSteps().addRandomRetargetingCondition(singleClient);
        api.as(agency).userSteps.bidModifiersSteps().shouldGetResultOn(
                subclient1,
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(conditionAnother)
                                .withDefaultBidModifier())
                        .withCampaignId(campaignID)),
                MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.RETARGETING_CONDITION_NOT_FOUND, conditionAnother)));
    }
}
