package ru.yandex.autotests.direct.api.bidmodifiers.add.retargeting;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 15.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Негативные сценарии добавления корректировок ставок ретаргетинга")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddBidModifiersRetargetingConditionsInvalidTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;
    private static final String clientAnother = BidModifiersLogins.SINGLE_CLIENT_ANOTHER;
    private static final long NON_METRICA_GOAL_ID = 2499000005L;

    private static Long campaignID;
    private static Integer conditionDeleted;
    private static Integer conditionAnother;
    private static Long nonMetricaCondition;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public BidModifierAddMap bidModifier;

    @Parameterized.Parameter(2)
    public MultiIdsExpectedResult expectedResult;

    @Parameterized.Parameter(3)
    public MultiIdsExpectedResult alternativeResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        prepareConditions();
        int nonExistionCondition = 1234567;
        return Arrays.asList(new Object[][]{
                {"Чужое условие ретаргетинга", new BidModifierAddMap().withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withDefaultBidModifier()
                        .withRetargetingConditionId(conditionAnother)),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.RETARGETING_CONDITION_NOT_FOUND, conditionAnother)),
                        null},
                {"Несуществующее условие ретаргетинга", new BidModifierAddMap().withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withDefaultBidModifier()
                        .withRetargetingConditionId(nonExistionCondition)),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.RETARGETING_CONDITION_NOT_FOUND, nonExistionCondition)),
                        null},
                {"Удаленное условие ретаргетинга", new BidModifierAddMap().withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withDefaultBidModifier()
                        .withRetargetingConditionId(conditionDeleted)),
                        MultiIdsExpectedResult.errors(new Notification(8800, Api5ErrorDetails.RETARGETING_CONDITION_NOT_FOUND, conditionDeleted)),
                        null},
                {"Отрицательный ID условия ретаргетинга", new BidModifierAddMap().withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withDefaultBidModifier()
                        .withRetargetingConditionId(-1)),
                        MultiIdsExpectedResult.errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER_BM,
                                StringUtils.capitalize(RetargetingAdjustmentMap.RETARGETING_CONDITION_ID))),
                        MultiIdsExpectedResult.errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER_BM,
                                "retargetingAdjustments[0]." + RetargetingAdjustmentMap.RETARGETING_CONDITION_ID))},
                //DIRECT-44052
                {"Нулевой ID условия ретаргетинга", new BidModifierAddMap().withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withDefaultBidModifier()
                        .withRetargetingConditionId(0)),
                        MultiIdsExpectedResult.errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER_BM,
                                StringUtils.capitalize(RetargetingAdjustmentMap.RETARGETING_CONDITION_ID))),
                        MultiIdsExpectedResult.errors(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER_BM,
                                "retargetingAdjustments[0]." + RetargetingAdjustmentMap.RETARGETING_CONDITION_ID))},
                // DIRECT-87867
                {"Условие ретаргетинга по профилю пользователя", new BidModifierAddMap().withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withDefaultBidModifier()
                        .withRetargetingConditionId(nonMetricaCondition)),
                        MultiIdsExpectedResult.errors(new Notification(6000, Api5ErrorDetails.UNSUPPORTED_RETARGETING_TYPE)),
                        null},
        });
    }

    private static void prepareConditions() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        conditionAnother = api.as(clientAnother).userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        conditionDeleted = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        api.userSteps.retargetingSteps().retargetingConditionDelete(conditionDeleted);
        nonMetricaCondition = createNonMetricaCondition();
    }

    private static Long createNonMetricaCondition() {
        RetargetingListAddItemMap retargetingListAddItemMap = new RetargetingListAddItemMap()
                .withType(RetargetingListTypeEnum.AUDIENCE)
                .withRandomName()
                .withRandomDescription()
                .withRules(new RetargetingListRuleItemMap()
                        .withArgumentItems(
                                new RetargetingListRuleArgumentItemMap()
                                        .withDefaultMembershipLifeSpan()
                                        .withExternalId(NON_METRICA_GOAL_ID))
                        .withOperator(RetargetingListRuleOperatorEnum.ANY));
         return api.as(client).userSteps.retargetingListsSteps().add(client,
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(retargetingListAddItemMap)).get(0);
    }

    @BeforeClass
    public static void prepareCampaign() {
        campaignID = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Test
    public void retargetingConditionTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(bidModifier
                        .withCampaignId(campaignID)),
                Collections.singletonList(expectedResult),
                Optional.ofNullable(alternativeResult).map(Collections::singletonList).orElse(null));
    }
}
