package ru.yandex.autotests.direct.api.bidmodifiers.add.retargeting;

import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingConditionResponse;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionGoalItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 02.06.16.
 * https://st.yandex-team.ru/TESTIRT-9385
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-54372")
@Features(BidModifiersFeatures.ADD)
@Description("Проверяем, что можно добавить корректировку с условием типа NOT в разные типы кампаний")
@RunWith(Parameterized.class)
public class AddBidModifiersRetargetingForNotTypeConditionTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;
    public static long goalIdWithGoalType = MetrikaGoals.getRandom();

    private Long campaignId;
    private Long adGroupId;
    private static Integer conditionIdWithNotType;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameters(name = "campaignType = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT},
                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC},
        });
    }


    @Before
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        RetargetingConditionResponse conditionResponse = api.userSteps.retargetingSteps().retargetingConditionAdd(
                new RetargetingConditionMap(api.type())
                        .defaultRetargeting(api.login())
                        .withRetargetingConditionItems(
                                new RetargetingConditionItemMap(api.type())
                                        .withType(RetargetingType.NOT)
                                        .withGoals(
                                                new RetargetingConditionGoalItemMap(api.type())
                                                        .withTime(1)
                                                        .withGoalID(goalIdWithGoalType)
                                        )
                        )
        );
        conditionIdWithNotType = conditionResponse.getActionsResult()[0].getRetargetingConditionID();
    }

    @Test
    @Description("Добавим корректировку ставки ретаргетинга с условием типа NOT")
    public void bidModifierWithNotTypeRetargetingConditionTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withBidModifier(BidModifierAddMap.DEFAULT_BID_MODIFIER)
                        .withRetargetingConditionId(conditionIdWithNotType))
                .withAdGroupId(adGroupId));

        assertThat("добавлена корректировка ставки ретаргетинга", bmIds, hasSize(1));
    }
}
