package ru.yandex.autotests.direct.api.bidmodifiers.add.retargeting;

import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.AddResponse;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.HazelcastAnnotations;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/TESTIRT-8519
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-48447")
@Description("Позитивные сценарии добавления корректировок ставок ретаргетинга")
public class AddBidModifiersRetargetingListsTest {
    private static final String CLIENT = BidModifiersLogins.SINGLE_CLIENT_RETARGETING_LISTS;
    private Long groupID;
    private Long campaignID;

    private final Long GOAL_ID1 = 18359650L;
    private final Long GOAL_ID2 = 18359655L;


    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareConditions() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Before
    @HazelcastAnnotations.Lock("direct.remove_retargeting_lists")
    public void createCampaign(){
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.retargetingSteps().retargetingConditionDelete(CLIENT);
    }

    @Test
    public void bidModifierWithForTargetsAndAdjustmentsRetargetingListsToGroup(){
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(GOAL_ID1)
                                                                        .withDefaultMembershipLifeSpan())
                                        )
                        ),
                ExpectedResult.success());

        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(addResponse.getAddResults().get(0).getId()))
                        .withAdGroupId(groupID));

        assertThat("добавлена корректировка ретаргетинга в группу", bmIds, hasSize(1));

    }


    @Test
    public void bidModifierWithForTargetsAndAdjustmentsRetargetingListsToCampaign(){
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.ANY)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(GOAL_ID2)
                                                                        .withDefaultMembershipLifeSpan())
                                        )
                        ),
                ExpectedResult.success());

        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(addResponse.getAddResults().get(0).getId()))
                        .withCampaignId(campaignID));

        assertThat("добавлена корректировка ретаргетинга в кампанию", bmIds, hasSize(1));

    }

    @Test
    public void bidModifierWithForAdjustmentsOnlyRetargetingListsToGroup(){
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(GOAL_ID1)
                                                                        .withDefaultMembershipLifeSpan())
                                        )
                        ),
                ExpectedResult.success());

        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(addResponse.getAddResults().get(0).getId()))
                        .withAdGroupId(groupID));

        assertThat("добавлена корректировка ретаргетинга в группу", bmIds, hasSize(1));
    }


    @Test
    public void bidModifierWithForAdjustmentsOnlyRetargetingListsToCampaign(){
        AddResponse addResponse = api.userSteps.retargetingListsSteps().shouldGetResultOnAdd(
                new ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap()
                        .withRetargetingLists(
                                new RetargetingListAddItemMap()
                                        .withRandomName()
                                        .withRandomDescription()
                                        .withRules(
                                                new RetargetingListRuleItemMap()
                                                        .withOperator(RetargetingListRuleOperatorEnum.NONE)
                                                        .withArgumentItems(
                                                                new RetargetingListRuleArgumentItemMap()
                                                                        .withExternalId(GOAL_ID2)
                                                                        .withDefaultMembershipLifeSpan())
                                        )
                        ),
                ExpectedResult.success());

        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(addResponse.getAddResults().get(0).getId()))
                        .withCampaignId(campaignID));

        assertThat("добавлена корректировка ретаргетинга в группу", bmIds, hasSize(1));
    }
}
