package ru.yandex.autotests.direct.api.bidmodifiers.add.retargeting;

import java.util.Collections;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;


/**
 * Created by chicos on 21.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Негативные сценарии добавления демографических корректировок ставок")
public class AddBidModifiersRetargetingNegativeTest {
    private static LogSteps log = LogSteps.getLogger(AddBidModifiersRetargetingNegativeTest.class);
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignID;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Test
    @Description("Использование одного условия ретаргетинга в нескольких объектах RetargetingAdjustment в одном запросе")
    public void sameRetargetingConditionInAdjustmentsTest() {
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withRetargetingAdjustment(
                                new RetargetingAdjustmentMap()
                                        .withDefaultBidModifier()
                                        .withRetargetingConditionId(conditionId),
                                new RetargetingAdjustmentMap()
                                        .withBidModifier(120)
                                        .withRetargetingConditionId(conditionId))
                        .withCampaignId(campaignID)),
                MultiIdsExpectedResult.errors(new Notification(9800, Api5ErrorDetails.RETARGETING_CONDITION_SHOULD_BE_PRESENTED_ONCE)));
    }

    @Test
    @Description("Добавляем ретаргетинговую корректировку ставок используя ранее использованное условие ретаргетинга")
    public void adjustmentIntersectionTest() {
        log.info("Добавим кампании корректировку ставок для условий ретаргетинга");
        Integer conditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        api.userSteps.bidModifiersSteps().addBidModifierRetargetingToCampaign(conditionId.longValue(), campaignID.intValue());
        log.info("Попробуем добавить пересекающуюся корректировку ставок ретаргетинга");
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap()
                        .withRetargetingAdjustment(
                                new RetargetingAdjustmentMap()
                                        .withBidModifier(120)
                                        .withRetargetingConditionId(conditionId))
                        .withCampaignId(campaignID)),
                singletonList(MultiIdsExpectedResult.errors(new Notification(9801))),
                singletonList(MultiIdsExpectedResult.errors(
                        new Notification(9801, Api5ErrorDetails.RETARGETING_LISTS_ALREADY_EXISTS_IN_GROUP))));
    }
}
