package ru.yandex.autotests.direct.api.bidmodifiers.add.retargeting;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.RetargetingConditionResponse;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionGoalItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.startsWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 15.07.2015.
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@Description("Позитивные сценарии добавления корректировок ставок ретаргетинга")
public class AddBidModifiersRetargetingTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;
    public static long goalIdWithAudienceSegmentType = MetrikaGoals.getRandomAudienceSegmentTypeGoal();

    private static Long campaignID;
    private static Integer conditionId1;
    private static Integer conditionId2;
    private static Integer conditionId3;
    private static Integer conditionId4;
    private static Integer conditionIdWithAudienceSegment;


    private final String ID_PREFIX = "12";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareConditions() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);

        conditionId1 = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        conditionId2 = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        conditionId3 = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        conditionId4 = api.userSteps.retargetingSteps().addRandomRetargetingCondition(client);
        RetargetingConditionResponse conditionResponse = api.userSteps.retargetingSteps().retargetingConditionAdd(
                new RetargetingConditionMap(api.type())
                        .defaultRetargeting(api.login())
                        .withRetargetingConditionItems(
                                new RetargetingConditionItemMap(api.type())
                                        .withType(RetargetingType.ALL)
                                        .withGoals(
                                                new RetargetingConditionGoalItemMap(api.type())
                                                        .withTime(1)
                                                        .withGoalID(goalIdWithAudienceSegmentType)
                                        )
                        )
        );
        conditionIdWithAudienceSegment = conditionResponse.getActionsResult()[0].getRetargetingConditionID();
    }

    @Test
    @Description("Добавим корректировку ставки ретаргетинга для группы")
    public void bidModifierToGroupTest() {
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withBidModifier(112)
                        .withRetargetingConditionId(conditionId1))
                .withAdGroupId(groupID));

        assertThat("добавлена корректировка ставки ретаргетинга", bmIds, hasSize(1));
    }

    @Test
    @Description("Добавим корректировку ставки ретаргетинга для кампании")
    public void bidModifierToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withBidModifier(111)
                        .withRetargetingConditionId(conditionId1))
                .withCampaignId(campaignID));

        assertThat("добавлена корректировка ставки ретаргетинга", bmIds, hasSize(1));
    }

    @Test
    @Description("Добавим несколько корректировок ставки ретаргетинга для кампании")
    public void multipleRetargetingAdjustmentToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionId2),
                        new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionId3))
                .withCampaignId(campaignID));

        assertThat("добавлены корректировки ставок ретаргетинга", bmIds, hasSize(2));
    }

    @Test
    @Description("Добавим несколько корректировок ставки ретаргетинга для группы")
    public void multipleRetargetingAdjustmentToGroupTest() {
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionId2),
                        new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionId3))
                .withAdGroupId(groupID));

        assertThat("добавлены корректировки ставок ретаргетинга", bmIds, hasSize(2));
    }

    @Test
    @Description("Добавим одинаковые корректировоки ретаргетинга для кампании и группы")
    public void sameRetargetingAdjustmentToGroupAndCampaignTest() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionId4))
                        .withAdGroupId(groupID),
                new BidModifierAddMap()
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .defaultRetargetingAdjustment()
                                .withRetargetingConditionId(conditionId4))
                        .withCampaignId(campaignID));

        assertThat("добавлены идентичные корректировки ретаргетинга в группу и кампанию", bmIds, hasSize(2));
    }

    @Test
    @Description("Идентификатор корректировки ставки ретаргетинга должен начинаться с префикса - " + ID_PREFIX)
    public void complexIdentificatorRetargetingTest() {
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withBidModifier(112)
                        .withRetargetingConditionId(conditionId1))
                .withAdGroupId(groupID));
        assumeThat("добавлена корректировка ставки ретаргетинга", bmIds, hasSize(1));

        assertThat("идентификатор корректировки ретаргетинга начинается с корректного префикса",
                String.valueOf(bmIds.get(0)), startsWith(ID_PREFIX));
    }

    @Test
    @Description("Добавим корректировку ставки ретаргетинга с я.аудиторией")
    public void bidModifierWithAudienceSegmentTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                        .withBidModifier(111)
                        .withRetargetingConditionId(conditionIdWithAudienceSegment))
                .withCampaignId(campaignID));

        assertThat("добавлена корректировка ставки ретаргетинга", bmIds, hasSize(1));
    }

}
