package ru.yandex.autotests.direct.api.bidmodifiers.add.retargeting;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierGetItemMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentGetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.CompareStrategy;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 01.02.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8037
 */
@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Установка ретаргетингового типа корректировки ставок для кампании типа ДТО")
public class AddRetargetingBidModifiersForDynamicTextCampaignTest {

    private static final String LOGIN = BidModifiersLogins.SINGLE_CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long groupId;
    private Integer retargetingConditionId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.as(LOGIN).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        groupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);

        retargetingConditionId = api.userSteps.retargetingSteps().addRandomRetargetingCondition(LOGIN);
    }

    @Test
    public void addRetargetingBidModifierForDTOCampaign() {
        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withAdGroupId(groupId)
                        .withRetargetingAdjustment(
                                new RetargetingAdjustmentMap()
                                        .withDefaultBidModifier()
                                        .withRetargetingConditionId(retargetingConditionId)
                        )
        );
        List<BidModifierGetItem> result = api.userSteps.bidModifiersSteps().bidModifiersGetByAdGroupId(groupId);

        CompareStrategy strategy = DefaultCompareStrategies.onlyExpectedFields();
        assertThat("вернулась верная корректировка", result, beanDiffer(
                Arrays.asList(
                    (BidModifierGetItem) new BidModifierGetItemMap()
                            .withRetargetingAdjustment(
                                    new RetargetingAdjustmentGetMap()
                                            .withDefaultBidModifier()
                            ).getBean()))
                .useCompareStrategy(strategy));
    }
}
