package ru.yandex.autotests.direct.api.bidmodifiers.add.serplayout;

import com.yandex.direct.api.v5.general.SerpLayoutEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(BidModifiersFeatures.ADD)
@Description("Негативные сценарии добавления корректировок ставок на позицию")
public class AddBidModifiersSerpLayoutNegativeTest {

    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;
    private static Long adGroupId;
    private static Long campaignId1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    @Description("Идентичные корректировки ставок на позицию в одном запросе")
    public void identicalAdjustmentsInRequestTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withSerpLayoutAdjustment(
                        new SerpLayoutAdjustmentMap().defaultSerpLayoutAdjustment(),
                        new SerpLayoutAdjustmentMap().defaultSerpLayoutAdjustment())
                        .withCampaignId(campaignId)),
                MultiIdsExpectedResult.errors(new Notification(9800,
                                Api5ErrorDetails.SELECTION_OF_ADJUSTMENTS_MAY_NOT_BE_PRESENT_MORE_THAN_ONCE),
                        new Notification(9800,
                                Api5ErrorDetails.SELECTION_OF_ADJUSTMENTS_MAY_NOT_BE_PRESENT_MORE_THAN_ONCE)));
    }

    @Test
    @Description("Добавляем корректировку ставок на позицию пересекающуюся с ранее добавленной")
    public void adjustmentIntersectionTest() {
        api.userSteps.bidModifiersSteps().addBidModifierSerpLayoutToCampaign(campaignId);
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withSerpLayoutAdjustment(
                        new SerpLayoutAdjustmentMap()
                                .withSerpLayout(SerpLayoutEnum.ALONE)
                                .withBidModifier(120))
                        .withCampaignId(campaignId)),
                MultiIdsExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.BID_MODIFIER_SERP_LAYOUT_ADJUSTMENT_INTERSECTION)));
    }

    @Test
    @Description("Добавляем корректировку ставок на группу")
    public void serpLayoutAdjustmentToGroupTest() {
        api.userSteps.bidModifiersSteps().shouldGetResultOn(
                Action.ADD,
                new AddRequestMap().withBidModifiers(new BidModifierAddMap().withSerpLayoutAdjustment(
                        new SerpLayoutAdjustmentMap().defaultSerpLayoutAdjustment())
                        .withAdGroupId(adGroupId)),
                MultiIdsExpectedResult.errors(new Notification(3500,
                        Api5ErrorDetails.ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED)));
    }
}
