package ru.yandex.autotests.direct.api.bidmodifiers.add.serplayout;

import java.util.List;

import com.yandex.direct.api.v5.general.SerpLayoutEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SerpLayoutAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.startsWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Features(BidModifiersFeatures.ADD)
@Description("Позитивные сценарии добавления корректировок ставок на позицию")
public class AddBidModifiersSerpLayoutTest {
    private static final String client = BidModifiersLogins.SINGLE_CLIENT_ADD;

    private static Long campaignId;

    private final String ID_PREFIX = "23";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Before
    @Description("Подготовим данные для теста")
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
    }

    @Test
    @Description("Добавим корректировку  на позицию для кампании")
    public void bidModifierToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                        .defaultSerpLayoutAdjustment())
                .withCampaignId(campaignId));

        assertThat("добавлена корректировка ставок на позицию", bmIds, hasSize(1));
    }

    @Test
    @Description("Добавим несколько корректировок  на позицию для кампании")
    public void multipleSerpLayoutAdjustmentToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                                .withSerpLayout(SerpLayoutEnum.SUGGEST)
                                .withDefaultBidModifier(),
                        new SerpLayoutAdjustmentMap()
                                .withSerpLayout(SerpLayoutEnum.ALONE)
                                .withDefaultBidModifier())
                .withCampaignId(campaignId));

        assertThat("добавлены корректировки ставок на позицию", bmIds, hasSize(2));
    }

    @Test
    @Description("Добавим несколько корректировок  на позицию для кампании в двух последовательных запросах")
    public void twoSerpLayoutAdjustmentToCampaignTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                        .withSerpLayout(SerpLayoutEnum.SUGGEST)
                        .withDefaultBidModifier())
                .withCampaignId(campaignId));

        assertThat("добавлена корректировка ставок на позицию", bmIds, hasSize(1));

        bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                        .withSerpLayout(SerpLayoutEnum.ALONE)
                        .withDefaultBidModifier())
                .withCampaignId(campaignId));

        assertThat("добавлена еще одна корректировка ставок на позицию", bmIds, hasSize(1));
    }

    @Test
    @Description("Идентификатор корректировки ставки  на позицию должен начинаться с префикса - " + ID_PREFIX)
    public void complexIdentificatorSerpLayoutTest() {
        List<Long> bmIds = api.userSteps.bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withSerpLayoutAdjustment(new SerpLayoutAdjustmentMap()
                        .defaultSerpLayoutAdjustment())
                .withCampaignId(campaignId));
        assumeThat("добавлена демографическая корректировка ставки", bmIds, hasSize(1));

        assertThat("идентификатор демографической корректировки ставки начинается с корректного префикса",
                String.valueOf(bmIds.get(0)), startsWith(ID_PREFIX));
    }
}
